#!/bin/perl -w

#  Simple command-line program to accept prompted user input for a file
#  name, read the file (of ballot comments in the wrong format) and
#  output a new file of the comments in the correct format.
#    -- Bob O'Hara (bob.ohara@ieee.org)

use strict;
require 5;

my $admin   = 'duncan.kitchin@intel.com';
my $VERSION = '2.0';

#  Version history:
#
#  2.0  - Extensively rewritten to work with new file format
#
#  1.03 - Replace mistaken full subclause reference in Clause: field
#         with only the major clause number
#  1.02 - literal character 0x0b replace with escaped cahracter \x0b
#         in substitution operation, extraneous variables removed
#  1.01 - minor format change to message sent to screen
#  1.0  - Original version with debuggin print statements commented out


print <<"Hello_Message";
This program will take a comment file created by the FileMaker
comment generation tool and convert its format to one that can
be read by the Access comment data base tool.

All you do is type what it asks for and press Return (or Enter)
to move to the next item.

Problems should be directed to $admin

Hello_Message


##  Ask for the file name of the input file and be sure we can open it
print <<"Input_file";

Enter the file name of the FileMaker file to be converted.
Include the complete path to the file, if it is not in the 
directory from which you ran this Perl script.

Input_file

print "Please enter the INPUT filename: ";
chomp( my $in = <> );

##  Open the input file as read-only, no chance to screw up the original
##  comments from the balloter
open INFILE, "<$in" or die "Can't open $in: $!";

##  print "Input file opened successfully!\n\n";

##  Now let's open the output file
print <<"Output_file";

Now enter the output file name.  If you don't enter a path with the
filename, the output file will be created in the current directory.

Output_file

##  Make sure we can write a file FIRST.
print "Please enter the OUTPUT filename: ";       
chomp( my $out = <> );
open  OUTFILE, ">$out" or die "Can't open $out: $!";

##  print "Output file created successfully!\n\n";

##  Print the header information that is required for the Access file
# this apparently not needed any more
# print OUTFILE "CommentID~CommenterName~CommenterEmail~CommenterPhone~CommenterFax~CommenterCo~Clause~Subclause~Page~Line~CommentType~Comment~SuggestedRemedy~Response~CommentStatus~ResponseStatus\n";

#print "\nHeader information output to file $out.\n\n";

my $line = ();
my $count = 0;
my $state = 0;
my $output = ();

##  process comments while not eof on INFILE;
while (!eof INFILE) {

	##  get the next line
	chomp ($line = <INFILE>);

	##  replace any existing "~" in the comments
	$line =~ s/~/<tilde>/g;

	##  return all '""' back to '"'
	$line =~ s/\"\"/\"/g;

	#print $line;

	# Change state based on what the line starts with
	#
	# state	0	not processing comment
	#		1	processing comment header
	#		2	processing comment text
	#		3	processing remedy text
	#
	if ($line =~ /CommenterName/) {

		#print "Changing state to 1\n";
		$state = 1;

		$count++;  ##  track the number of comments processed
		# empty the line
		$output = ();

	}
	if ($line =~ /Comment:/) {

		#print "Changing state to 2\n";
    $line =~ s/Comment:/~/;
		$state = 2;
	}
	if ($line =~ /CommentEnd:/) {

		#print "Changing state to 1\n";
    $line =~ s/CommentEnd://;
		$state = 1;
	}
	if ($line =~ /SuggestedRemedy:/) {

		#print "Changing state to 3\n";
    $line =~ s/SuggestedRemedy:/~/;
		$state = 3;
	}
	if ($line =~ /RemedyEnd/) {

		#print "Changing state to 0\n";
		$state = 0;


		print OUTFILE $output . "~~X~O\n";
	}

	
	# now go and look for the fields we want
	if ($state == 1) {
		if ($line =~ /CommenterName:/) {
			$line =~ s/CommenterName:/0~/;
			$output = $line;
		}
		if ($line =~ /CommenterEmail:/) {
	    $line =~ s/CommenterEmail:/~/;
      $output = $output . $line;
		}
		if ($line =~ /CommenterPhone:/) {
      $line =~ s/CommenterPhone:/~/;
      $output = $output . $line;
		}
		if ($line =~ /CommenterCellPhone:/) {
      $line =~ s/CommenterCellPhone:/~/;
      $output = $output . $line;
		}
		if ($line =~ /CommenterCompany:/) {
      $line =~ s/CommenterCompany:/~/;
      $output = $output . $line;
		}
		if ($line =~ /Clause:/) {
      $line =~ s/ 2/02/;
      $line =~ s/ 3/03/;
      $line =~ s/ 4/04/;
      $line =~ s/ 5/05/;
      $line =~ s/ 6/06/;
      $line =~ s/ 7/07/;
      $line =~ s/ 9/09/;
      $line =~ s/Clause:/~/;
      $output = $output . $line;
		}
		if ($line =~ /Subclause:/) {
      $line =~ s/Subclause:/~/;
      $output = $output . $line;
		}
		if ($line =~ /Page:/) {
      $line =~ s/Page:/~/;
      $output = $output . $line;
		}
		if ($line =~ /Line:/) {
      $line =~ s/Line:/~/;
      $output = $output . $line;
		}
		if ($line =~ /CommentType \(E\, T or TR\):/) {
      $line =~ s/CommentType \(E\, T or TR\):/~/;
      $output = $output . $line;
		}
		if ($line =~ /CommentType \(E\, T\, or TR\):/) {
      $line =~ s/CommentType \(E\, T\, or TR\):/~/;
      $output = $output . $line;
		}
	}

  if ($state == 2) {
    $output = $output . " " . $line;
  }
  if ($state == 3) {
    $output = $output . " " . $line;
  }
	
	
	}

##  Close both the input and output files
close INFILE;
close OUTFILE;

print "Processing of $count comments in $in is complete.\n$out written and closed.\n";
exit 0;


