function [ output_args ] =com2l(config_file, num_fext, num_next, varargin)
% For use in the development if IEEE802.3bj channel specification
% This is not a normatative or an official IEEE document
% This code is exected to change as the IEEE802.3bj documment evolves
% Version 1.0 08/14/2012
% Version 1.01 08/17/2012 updating to draft and adding more parameter to xls sheet
% Version 1.02 08/31/2012 fix parcing for PAM4, added maxdfex code. 
% Verson  1.05 has new vtf and apply to all s parameters IEEE posted
% version d1p2 added package IL and package RL per draft 1.2
%              pkg parameter removed and set by xls
%              noise included in h_ISI region for pam4 base on param.maxcx
%              precuror ISI include in PDF as well as noise in DFE region
%              Noise updated to Draft 1.2 spec in FOM calcuation
%              now XLS input is alway required.
%              package ref frequency is now absolute
% version d1p2a fixed sweeping equaliztion cursor finding bug that occur if
%              eq paremeters are altered in xls sheet
% version d1p21b name change to reflect doc file


%%
close all force
display('COM2L for Draft 1.2b')
display(sprintf('\tThis code is expected to change as the IEEE802.3bj document evolves. \n\tThis is not a normative or an official IEEE document.'))
% need to see what happens for version 8
OP.VEROK=verLessThan('matlab', '7.4.1');
if OP.VEROK; display('Matlab version 7.4 or higher required'); return; end
if ~exist('config_file','var')
    config_file=input('Enter config XLS file or return will just pop a window to ask for the XLS file]:  ','s') ;
end
if ~exist('num_fext','var')
    num_fext=input('How many FEXT channels are to be entered? [return is means no FEXT] ');
    if isempty(num_fext)==1 num_fext=0; end
end
if ~exist('num_next','var')
    num_next=input('How many NEXT channels are to be entered? [return is means no NEXT] ');
    if isempty(num_next)==1 num_next=0; end
end

xtk=num_fext+num_next; % tolal number of crosstalk agressors
param.exist=1; % Just defines the base structure param
% get config file, test if passed, if not pop window to ask
if strfind(upper(config_file),'.XLS') ~= 0
    file = config_file;
    [param OP] = read_ParamConfigFile(file, param, OP);
    pkg=OP.INC_PACKAGE_RL;
    if pkg == 0
        param.inc_pkg='N';
    else
        param.inc_pkg='Y';
    end
else % ask for config file
    [file,pth] = uigetfile({'*.xls'},'INPUT CONFIG FILE .xls');
    [param OP] = read_ParamConfigFile(file, param, OP);
    pkg=OP.INC_PACKAGE_RL;
    if pkg == 0
        param.inc_pkg='N';
    else
        param.inc_pkg='Y';
    end
end

if ~exist(OP.RESULT_DIR,'dir'); mkdir(OP.RESULT_DIR); end
% allow impulse response input rather that s-parameters
OP.EXTERNAL = false;
if size(varargin,2) ~= 0
    if strfind(upper(char(varargin(1))),'EXTERNAL_IR') ~= 0
        OP.EXTERNAL = true;
        OP.GET_FD = 0;
        % very restrictive call sequence
        % varargin(3... are ir's
        ir1a= varargin(2);
        %   ir(1) ~ thru
        %   ir(2:num_fext+1) ~ ir fext 
        %   ir(num_fext+1:num_fext+2+numnext) ~ ir nest
        ex_var = varargin(3); 
        % resamples data for Chan2l Usage.
        % creates chdata.ir mad chdata.it
        % external use requires passing the impulse response and ajusting
        % structruces OP param chadata and ex_var
        [chdata OP param ]  = use_external_IR(param, OP ,num_fext,num_next,0,ir1a,ex_var);
        % external call with inpulse responses looks like this 
        %   output_args = com2L_r###('config.xls',n,m,0,ir1a,sigsim_var)
        nxi=num_fext+num_next+1;
    else
        OP.EXTERNAL = false;
        if xtk +1 ~= size(varargin,2)
            display('total files must be next + fext + a thur')
            return
        end
    end
end

if OP.EXTERNAL == false
    %%  filename parsing and aquisition
    %------------------------------------------------------------------
    %-----------------------  Get Files -------------------------------
    % If thru is present then it will always be index of 1
    % However if not present the first crosstalk will be an index of 1
    get_file=1;
    xlspth=[];
    nxi=0; % file index
    if param.thru == 1
        % get the file
        if size(varargin,2) ~= 0
            varargin(1)=strrep(varargin(1),'\','/');
            fle=cell2mat(varargin(1));
            name_pos= find(fle=='/',1,'last')+1;
            xls=fle(name_pos:end);
            xlspth=fle(1:name_pos-1);
        else
            dir=[xlspth '*.s4p'];
            dir=strrep(dir,'\','/');
            [xls,xlspth]=uigetfile(dir,'input thru channel response .s4p ');
            xlspth=strrep(xlspth,'\','/');
        end
        if xlspth ~= 0
            nxi=nxi+1;
            % now process file name
            string=[xlspth xls];
            filename(nxi,1:length(string)) = string(1:end);
            outdir(nxi,1:length(xlspth))=xlspth(1:end);
            pos=strfind(lower(filename(nxi,:)) ,'.');
            spos=strfind(lower(filename(nxi,:)) ,'/');
            ext(nxi,:)=filename(nxi,pos(end):length(string));
            chdata(nxi).base=filename(nxi,spos(end-1)+1:pos(end)-1);
            chdata(nxi).base=strrep(chdata(nxi).base,'/','--');
            chdata(nxi).A=param.a_thru; % pam encoding amplitude reduction is do in reporting but is comprehending in crosstalk PDF
            chdata(nxi).type='THRU'; % thru type
            chdata(nxi).ftr=param.fb*param.f_v;
        else
            if nxi==0
                display('no input files')
                return;
            end
            get_file=0;
        end
    end
    kxi=nxi;
    for nxi=kxi+1:num_fext+kxi
        if size(varargin,2) ~= 0
            varargin(nxi)=strrep(varargin(nxi),'\','/');
            fle=cell2mat(varargin(nxi));
            name_pos= find(fle=='/',1,'last')+1;
            xls=fle(name_pos:end);
            xlspth=fle(1:name_pos-1);
        else
            dir=[xlspth '*.s4p'];
            dir=strrep(dir,'\','/');
            [xls,xlspth]=uigetfile(dir,['input fext channel response .s4p #', num2str(nxi-kxi)]);
            xlspth=strrep(xlspth,'\','/');
        end
        if xlspth ~= 0
            % now process file name
            string=[xlspth xls];
            filename(nxi,1:length(string)) = string(1:end);
            outdir(nxi,1:length(xlspth))=xlspth(1:end);
            pos=strfind(lower(filename(nxi,:)) ,'.');
            spos=strfind(lower(filename(nxi,:)) ,'/');
            ext(nxi,:)=filename(nxi,pos(end):length(string));
            chdata(nxi).base=filename(nxi,spos(end)+1:pos(end)-1);
            chdata(nxi).A=param.a_fext;
            chdata(nxi).ftr=param.fb*param.f_f;
            chdata(nxi).type='FEXT'; % fext type
        else
            if nxi==0
                display('no input files')
                return;
            end
            get_file=0;
        end
    end
    kxi=num_fext+kxi;
    for nxi=kxi+1:num_next+kxi
        if size(varargin,2) ~= 0
            varargin(nxi)=strrep(varargin(nxi),'\','/');
            fle=cell2mat(varargin(nxi));
            name_pos= find(fle=='/',1,'last')+1;
            xls=fle(name_pos:end);
            xlspth=fle(1:name_pos-1);
        else
            dir=[xlspth '*.s4p'];
            dir=strrep(dir,'\','/');
            [xls,xlspth]=uigetfile(dir,['input next channel response .s4p ', num2str(nxi-kxi)]);
             xlspth=strrep(xlspth,'\','/');
        end
        if xlspth ~= 0
            % now process file name
            string=[xlspth xls];
            filename(nxi,1:length(string)) = string(1:end);
            outdir(nxi,1:length(xlspth))=xlspth(1:end);
            pos=strfind(lower(filename(nxi,:)) ,'.');
            spos=strfind(lower(filename(nxi,:)) ,'/');
            ext(nxi,:)=filename(nxi,pos(end):length(string));
            chdata(nxi).base=filename(nxi,spos(end)+1:pos(end)-1);
            chdata(nxi).A=param.a_next;
            chdata(nxi).ftr=param.fb*param.f_n;
            chdata(nxi).type='NEXT'; % next type
        else
            if nxi==0
                display('no input files')
                return;
            end
            get_file=0;
        end
    end

    %% extract s-parameter data from files and apply tx and rx filters as well as package filters
    nxi=num_next+kxi;
    for i=1:nxi
        hwaitbar=waitbar(0);
        progress = (i-1)/nxi;
        waitbar(progress, hwaitbar, 'reading files'); drawnow;
        
        switch ext(i,:)
            case '.s4p'
                if ~isfield(param,'snpPortsOrder') || isempty(param.snpPortsOrder)
                    param.snpPortsOrder = [1 3 2 4]; % default order normally used.
                elseif length(param.snpPortsOrder) ~= 4
                    error( 'warning:sNpFilePortMismatch', ...
                        '\n\t The number of ports defined (%G) does not match the sNp file type (%s)', ...
                        length(param.snpPortsOrder), ...
                        ext(i,:) ...
                        );
                end
                [Sch SDDch] = read_p4_s4params(filename(i,:),  0, 0, param.snpPortsOrder);
                chdata(i).fmaxi = length(Sch.freq);
                chdata(i).faxis = Sch.freq;
                chdata(i).sdd21 = transpose(SDDch(1:chdata(i).fmaxi,2,1));
                chdata(i).sdd22 = transpose(SDDch(1:chdata(i).fmaxi,2,2));
                chdata(i).sdd11 = transpose(SDDch(1:chdata(i).fmaxi,1,1));
                
            case '.s12p'
                if ~isfield(param,'snpPortsOrder') || isempty(param.snpPortsOrder)
                    param.snpPortsOrder = [1 2 3 4 6 7 8 9 10 11 12]; % default order normally used.
                elseif length(param.snpPortsOrder) ~= 12
                    error( 'warning:sNpFilePortMismatch', ...
                        '\n\t The number of ports defined (%G) does not match the sNp file type (%s)', ...
                        length(param.snpPortsOrder), ...
                        ext(i,:) ...
                        );
                end
                Sch = readdataSnPx(filename(i,:), 12);
                chdata(i).fmaxi = length(Sch.freq);
                chdata(i).faxis = Sch.freq;
                if isequal([1 3 5 7 9 11 2 4 6 8 10 12], param.snpPortsOrder)
                    chdata(i).sdd21 = reduce((Sch.cs(6,5,1:chdata(i).fmaxi)-Sch.cs(8,5,1:chdata(i).fmaxi)-Sch.cs(6,7,1:chdata(i).fmaxi)+Sch.cs(8,7,1:chdata(i).fmaxi))./2); %dd21=s21-s41-s23+s43
                    chdata(i).sdd11 = reduce((Sch.cs(5,5,1:chdata(i).fmaxi)-Sch.cs(7,5,1:chdata(i).fmaxi)-Sch.cs(5,7,1:chdata(i).fmaxi)+Sch.cs(7,7,1:chdata(i).fmaxi))./2); %dd11=s11-s31-s13+s33
                    chdata(i).sdd22 = reduce((Sch.cs(6,6,1:chdata(i).fmaxi)-Sch.cs(6,8,1:chdata(i).fmaxi)-Sch.cs(8,6,1:chdata(i).fmaxi)+Sch.cs(8,8,1:chdata(i).fmaxi))./2); %dd22=s22-s41-s14+s44
                elseif isequal([1 2 3 4 5 6 7 8 9 10 11 12], param.snpPortsOrder)
                    chdata(i).sdd21 = reduce((Sch.cs(9,3,1:chdata(i).fmaxi)-Sch.cs(10,3,1:chdata(i).fmaxi)-Sch.cs(9,4,1:chdata(i).fmaxi)+Sch.cs(10,4,1:chdata(i).fmaxi))./2);  %dd21=s21-s41-s23+s43
                    chdata(i).sdd11 = reduce((Sch.cs(3,3,1:chdata(i).fmaxi)-Sch.cs(4,9,1:chdata(i).fmaxi)-Sch.cs(3,4,1:chdata(i).fmaxi)+Sch.cs(4,4,1:chdata(i).fmaxi) )/2);    %dd11=s11-s31-s13+s33
                    chdata(i).sdd22 = reduce((Sch.cs(9,9,1:chdata(i).fmaxi)-Sch.cs(10,3,1:chdata(i).fmaxi)-Sch.cs(9,10,1:chdata(i).fmaxi)+Sch.cs(10,10,1:chdata(i).fmaxi) )/2);%dd22=s22-s41-s14+s44
                else
                    display('INVALID ENTRY FOR TX PORTS.  Use [1 2 3 4 5 6] or [1 3 5 7 9 11]')
                    return
                end
            otherwise
        end
        %
        % differential response is sdd21 <------------------------------
        % differential return losses are sdd11 nad sdd22
        chdata(i).sdd21p= s21_pkg(chdata(i).sdd21, chdata(i).sdd11, chdata(i).sdd22, chdata(i).faxis, param, OP)   ;
        chdata(i).sdd21f=chdata(i).sdd21; % used for FD analysis i.e. not filtered
        if  OP.INC_PACKAGE_RL ~= 0,
            chdata(i).sdd21=chdata(i).sdd21p;
        end        
        chdata(i).sdd21=chdata(i).A*chdata(i).sdd21; % adjust for max signal for thru, next, fext; i.e. done after package RL because s11, s22 are normialized units
        %     if  chdata(i).faxis(end) < 1/param.ui % ha ha  got any ideas here. If we don't have twice nyquist we go home
        %         display('data does not have wide enough bandwidth. result may be not be reliable')
        %     end
        % define rise time to be 20% of UI and rise time filter
        if OP.INCLUDE_FILTER ~=0
            bw0=sqrt(2);
            Trf_filter=1./(1-(chdata(i).faxis./chdata(i).ftr).^2+1i*sqrt(2).*(chdata(i).faxis./chdata(i).ftr))  ;
            bw1=2.613126; bw2=3.4142136; bw3=2.613126; fr=param.f_r*param.fb;
            Vrx_filter=(1+bw1*1i*chdata(i).faxis./fr+bw2*(1i*chdata(i).faxis./fr).^2+bw3*(1i*chdata(i).faxis./fr).^3+(1i*chdata(i).faxis./fr).^4).^-1;
            chdata(i).sdd21=chdata(i).sdd21.*Trf_filter.*Vrx_filter; % adjust w/rise time filter
            if OP.INC_PACKAGE_IL ~=0
                Htx=pkg_loss(chdata(i).faxis, param, OP);
                chdata(i).sdd21=chdata(i).sdd21.*Htx.*Htx;
            end
        end
    end
end
%%
% at this point sdd21 responses and faxis (frequency) array are defined
% ----------
% first find equalization settings
%            When a thru channel is give and it should be unless we are in a
%            diagnostic mode
%
%
ICN=0;
for i=1:nxi
    if OP.GET_FD~=0
        if i == 2, PSXT(1:length(chdata(i).sdd21f))=0;end
        a=find(chdata(i).faxis(:)>param.f2);
        if isempty(a)
            param.f2=chdata(i).faxis(length(chdata(i).faxis));
            index_f2=length(chdata(i).faxis);
        else
            index_f2=a(1);
        end
        % R is the frequency dependa parameter for the sinc function use in the
        % PWF for ICN
        temp_angle=(param.samples_per_ui*param.sample_dt)*pi.*chdata(i).faxis;
        if(chdata(i).faxis(1)==0)
            temp_angle(1)=1e-20;% we don't want to divide by zero
        end
        SINC = sin(temp_angle)./temp_angle;
        PWF_data=SINC.^2;
        PWF_trf=(1+(chdata(i).faxis/chdata(i).ftr).^4).^-1;
        bw1=2.613126; bw2=3.4142136; bw3=2.613126; fr=param.f_r*param.fb;
        PWF_rx=(1+(chdata(i).faxis/fr).^8).^-1;
        %PWF_rx=1./(1+(chdata(i).faxis./(param.fb*.75)).^8); % receiver filter
        PWF_highpass=1;
        PWF=PWF_data.*PWF_trf.*PWF_rx.*PWF_highpass; % power weight function
        % freq delta for integration
        chdata(i).delta_f=chdata(i).faxis(11)-chdata(i).faxis(10);
        % from ba spec, this is basically ICN
        chdata(i).sigma_FD=sqrt(2*chdata(i).delta_f/param.fb*sum( PWF(1:index_f2).*abs(chdata(i).sdd21f(1:index_f2)).^2))/2;
        if i==1 && param.thru
            [chdata(i).iln chdata(i).fit] = get_ILN(chdata(i).sdd21f, chdata(i).faxis);
            nq_indx=find(chdata(i).faxis >= 1/param.ui/2,1, 'first');
            chdata(i).fit_ILatNq=-20*log10(abs(chdata(i).fit(nq_indx)));
            chdata(i).ILatNq=-20*log10(abs(chdata(i).sdd21f(nq_indx)));
            fit_loss=chdata(i).fit_ILatNq;
            Nq_loss=chdata(i).ILatNq;
            ILD=20*log10(abs(chdata(i).fit))-20*log10(abs(chdata(i).sdd21f));
            ILD_RMS=sqrt(2*chdata(i).delta_f/param.fb*sum( PWF(1:index_f2).*ILD(1:index_f2).^2));
            if OP.DEBUG
                display(['Insertion Loss at Nyquist = ', num2str(chdata(i).ILatNq)])
            end
            if OP.DISPLAY_WINDOW
                figure(300)
                subplot(3,1,1)
                title('Losses')
                plot(chdata(i).faxis,20*log10(abs(chdata(i).sdd21f)),'Disp','IL')
                hold on
                plot(chdata(i).faxis,20*log10(abs(chdata(i).fit)),'g','Disp','IL fit')
                plot(chdata(i).faxis,20*log10(abs(chdata(i).sdd11)),'c','Disp','RL11')
                plot(chdata(i).faxis,20*log10(abs(chdata(i).sdd22)),'- c','Disp','RL22')
                hold off
                subplot(3,1,3)
                plot(chdata(i).faxis,ILD,'Disp','ILD')
            end
        else
            PSXT=sqrt((abs(chdata(i).sdd21f)).^2+PSXT.^2); % power sum xtk
            ICN=sqrt(2*chdata(i).delta_f/param.fb*sum( PWF(1:index_f2).*abs(PSXT(1:index_f2)).^2))/2;
        end
    end
end
%%
% at this point sdd21 responses and faxis (frequency) array are defined
% ----------
% first find equalization settings
%            When a thru channel is give and it should be unless we are in a
%            diagnostic mode
%
%
ICN=0;
for i=1:nxi
    if OP.GET_FD~=0
        if i == 2, PSXT(1:length(chdata(i).sdd21f))=0;end
        a=find(chdata(i).faxis(:)>param.f2);
        if isempty(a)
            param.f2=chdata(i).faxis(length(chdata(i).faxis));
            index_f2=length(chdata(i).faxis);
        else
            index_f2=a(1);
        end
        % R is the frequency dependa parameter for the sinc function use in the
        % PWF for ICN
        temp_angle=(param.samples_per_ui*param.sample_dt)*pi.*chdata(i).faxis;
        if(chdata(i).faxis(1)==0)
            temp_angle(1)=1e-20;% we don't want to divide by zero
        end
        SINC = sin(temp_angle)./temp_angle;
        PWF_data=SINC.^2;
        PWF_trf=(1+(chdata(i).faxis/chdata(i).ftr).^4).^-1;
        bw1=2.613126; bw2=3.4142136; bw3=2.613126; fr=.75*param.fb;
        PWF_rx=(1+(chdata(i).faxis/fr).^8).^-1;
        %PWF_rx=1./(1+(chdata(i).faxis./(param.fb*.75)).^8); % receiver filter
        PWF_highpass=1;
        PWF=PWF_data.*PWF_trf.*PWF_rx.*PWF_highpass; % power weight function
        % freq delta for integration
        chdata(i).delta_f=chdata(i).faxis(11)-chdata(i).faxis(10);
        % from ba spec, this is basically ICN
        chdata(i).sigma_FD=sqrt(2*chdata(i).delta_f/param.fb*sum( PWF(1:index_f2).*abs(chdata(i).sdd21f(1:index_f2)).^2))/2;
        if i==1 && param.thru
            [chdata(i).iln chdata(i).fit] = get_ILN(chdata(i).sdd21f, chdata(i).faxis);
            nq_indx=find(chdata(i).faxis >= 1/param.ui/2,1, 'first');
            chdata(i).fit_ILatNq=-20*log10(abs(chdata(i).fit(nq_indx)));
            chdata(i).ILatNq=-20*log10(abs(chdata(i).sdd21f(nq_indx)));
            fit_loss=chdata(i).fit_ILatNq;
            Nq_loss=chdata(i).ILatNq;
            ILD=20*log10(abs(chdata(i).fit))-20*log10(abs(chdata(i).sdd21f));
            ILD_RMS=sqrt(2*chdata(i).delta_f/param.fb*sum( PWF(1:index_f2).*ILD(1:index_f2).^2));
            if OP.DEBUG
                display(['Insertion Loss at Nyquist = ', num2str(chdata(i).ILatNq)])
            end
            if OP.DISPLAY_WINDOW
                figure(300)
                subplot(3,1,1)
                title('Losses')
                plot(chdata(i).faxis,20*log10(abs(chdata(i).sdd21f)),'Disp','IL')
                hold on
                plot(chdata(i).faxis,20*log10(abs(chdata(i).fit)),'g','Disp','IL fit')
                plot(chdata(i).faxis,20*log10(abs(chdata(i).sdd11)),'c','Disp','RL11')
                plot(chdata(i).faxis,20*log10(abs(chdata(i).sdd22)),'- c','Disp','RL22')
                hold off
                subplot(3,1,3)
                plot(chdata(i).faxis,ILD,'Disp','ILD')
            end
        else
            PSXT=sqrt((abs(chdata(i).sdd21f)).^2+PSXT.^2); % power sum xtk
            ICN=sqrt(2*chdata(i).delta_f/param.fb*sum( PWF(1:index_f2).*abs(PSXT(1:index_f2)).^2))/2;
        end
    end
end
if OP.DISPLAY_WINDOW && OP.GET_FD ~=0
    figure(300)
    if nxi > 1
        subplot(3,1,1)
        hold on
        plot(chdata(2).faxis,20*log10(abs(PSXT)),'r','Disp','PSXT')
        subplot(3,1,2)
        ICR=-20*log10(abs(PSXT))+20*log10(abs(chdata(1).sdd21f));
        semilogx(chdata(2).faxis,ICR,'Disp','ICR')
        hold off
    end
    h1=figure(300);
    set(h1,'Position', [20 20 800 800] );
    subplot(3,1,1)
    title('Losses')
    ylabel('dB')
    xlabel('Hz')
    subplot(3,1,2)
    ylim([0 80])
    ylabel('dB')
    xlabel('Hz')
    title('ICR')
    subplot(3,1,3)
    ylim([-8 8])
    ylabel('dB')
    xlabel('Hz')
    title('ILD')
    hold off
end
%% at this point only the impulse responses are needed. However vestigages FD may be intermingled
for i=1:nxi
    % Frequency domain section opererate on un processed - s-parameters but may
    % or may not include packages
    if i==1 && param.thru
        if OP.EXTERNAL == false
            [IRx chdata(i).t] = s21_to_impulse_DC(chdata(i).sdd21 ,chdata(i).faxis,param.sample_dt) ;
            RAWSBR=conv(ones(param.samples_per_ui,1),IRx);
        else
            % chdata(i).t  and chdata(i).ir defined in get external
            IRx=chdata(i).ir;
        end
        result= sweep_eq(IRx,OP,param);
        [reduce_sbr tci tzi]=find_g_param(result.IR,param);
        % result.eq.txle
        % result.eq.ctle.zero
        % result.eq.ctle.pole1
        % result.eq.ctle.pole2
        % result.eq.ctle.maxgain=20*log10(max(abs(ctle_gain)));
        % result.eq.ctle.maxkacdc=best_ctle.kacdc;
        % result.IR
        % result.PR
        % result.avail_signal
        % result.avail_sig_index
        % result.best_SNR_ISI=best_SNR_ISI;
        chdata(i).IRx=result.IR(1:length(chdata(i).t)); % use teh equalized channel impulse response
        max_signal=result.avail_signal; % this is the "s" in SNR (PAM4 gain in handled in last sections
    else
        % add CTLE to crosstalk. Tx and Rx filter already added
        %         if param.thru~=0
        %             ctle_gain=param.fb*(1i.*chdata(i).faxis+0.25*param.fb*result.eq.ctle.maxkacdc)./((1i*chdata(i).faxis+0.25*param.fb).*(1i*chdata(i).faxis+param.fb));
        %            % ctle_gain=(1+1i*2*pi*chdata(i).faxis/result.eq.ctle.zero)./((1+1i*2*pi*chdata(i).faxis/result.eq.ctle.pole1).*(1+1i*2*pi*chdata(i).faxis/result.eq.ctle.pole2))/result.eq.ctle.maxkacdc;
        %         else
        %             ctle_gain=1; % make ctle=1 if not thru is specified.
        %             OP.INCLUDE_CTLE=0;
        %         end
        % if OP.INCLUDE_CTLE==1; chdata(i).sdd21=chdata(i).sdd21.*ctle_gain; end
        if OP.EXTERNAL == false
            [IRx chdata(i).t] = s21_to_impulse_DC(chdata(i).sdd21 ,chdata(i).faxis,param.sample_dt) ;
            
        else
            % chdata(i).t  and chdata(i).ir defined in get external
            IRx=chdata(i).ir;
        end
        if OP.INCLUDE_CTLE==1; IRx  = TD_CTLE(IRx,param.fb,result.eq.ctle.maxkacdc,param.samples_per_ui);end
        % need to add in the tx ff3 filter here if FEXT
        if chdata(i).type=='FEXT'
            upsampled_txffe = zeros(1, param.samples_per_ui*2+1); % start with zeros everywhere
            upsampled_txffe(1+(0:2)*param.samples_per_ui) = result.eq.txle; % plant the coefficients in the desired locations
            IRx = conv(IRx,upsampled_txffe );
            IRx = IRx((param.samples_per_ui*2+1):(param.samples_per_ui*2)+length(chdata(i).t)); % back shift
        end
        
        chdata(i).IRx=IRx;
        if i== 1 max_signal=1; end
    end
    
    
    %------------------------------------------------------------
    % at this point we have filtered impulse responses defined
    %
    % next we find Pulse response (SBR) for each channel
    chdata(i).result=get_BR(chdata(i).IRx, chdata(i).t, param.samples_per_ui);
    if OP.SAVE_RESP ~= 0
        t=chdata(i).t;
        SBR=chdata(i).result.SBR;
        ir=chdata(i).IRx;
        if OP.GET_FD == 1
            IL_fil=chdata(i).sdd21;
            IL=chdata(i).sdd21f;
            f=chdata(i).faxis;
        end
        UI=param.ui;
        if OP.GET_FD == 1
            save([chdata(i).base '_channel_data.mat'],'t','SBR','RAWSBR','ir', 'f','IL', 'IL_fil','UI')
        else
            save([chdata(i).base '_channel_data.mat'],'t','SBR','RAWSBR','ir')
        end                    
    end    
    
    %     if i==1 && param.thru
    %         [chdata(i).pr_peak chdata(i).main_cursor]=max(chdata(i).result.DR);
    %     end
    % plot results
    if OP.DEBUG
        figure(i+150)
        plot(chdata(i).t, chdata(i).result.SBR,'Disp',[chdata(nxi).base ' - PR'])
        title(strrep(chdata(i).base,'_',' '))
        ylabel('Volts')
        xlabel('seconds')            
    end
    % get quick PDF  results
    if(chdata(i).type=='THRU')
        excluded_UI=param.ndfe;
    else
        excluded_UI=0;
    end
    % the max signal here comprehends drive strenth but no coding, that is
    % taken care of within 30db_from_sampled_signal called by get_pdf
[pdf] = get_pdf(max_signal, excluded_UI, i, chdata, param, OP) ;
    chdata(i).pdfr=pdf;
    
    % plot FD vs TD PDF
    
    if OP.DEBUG
        figure(200)
        semilogy(chdata(i).pdfr.x,chdata(i).pdfr.y,'r','Disp','Gaussian noise from PR processed estimite')
        hold on
        ylim([1e-12 1])
        ylabel('Probability (log10)')
        xlabel('volts')
        hold off
    end
    % find at y=ber(1e-12)
    % reporting
    a=find(cumsum(chdata(i).pdfr.y) >1e-12,1,'first');
    chdata(i).maxquickpdf=(chdata(i).pdfr.y(a));
    if OP.DEBUG
        if OP.GET_FD~=0, display([chdata(i).base ' FD rms (mv) =' num2str(1000*chdata(i).sigma_FD) ]);end
        if (param.ndfe ~=0 )display([ ' Pulse Heigth = ' num2str(max(chdata(i).result.SBR)) ]);end
    end
end
% plot FD data

%%%%%%%%%%%%%%%%%%%
for i=1:nxi
    if chdata(i).type== 'THRU'
        sci_pdf = chdata(i).pdfr;
        if OP.GET_FD ~=0, FD_rms_sci=chdata(i).sigma_FD; end % decide later whether to use FD or TD rms. pdfr has an rms field.
    else
        if chdata(i).type== 'NEXT';
            if ~exist('MDNEXT_cci_pdf','var')
                MDNEXT_cci_pdf=chdata(i).pdfr;
            else
                MDNEXT_cci_pdf=conv_fct(MDNEXT_cci_pdf,chdata(i).pdfr); % adee's conv fct
            end
        end
        if chdata(i).type== 'FEXT';
            if ~exist('MDFEXT_cci_pdf','var')
                MDFEXT_cci_pdf=chdata(i).pdfr;
            else
                MDFEXT_cci_pdf=conv_fct(MDFEXT_cci_pdf,chdata(i).pdfr); % adee's conv fct
            end
        end
        if ~exist('joint_cci_pdf','var')
            joint_cci_pdf = chdata(i).pdfr;
        else
            joint_cci_pdf = conv_fct(joint_cci_pdf,chdata(i).pdfr); % adee's conv fct
        end
    end
end

% combine cci ad sci
if param.thru~=0 & xtk~=0 % must  have pass thru and xtlk
    joint_pdf = conv_fct(joint_cci_pdf,sci_pdf);
%    joint_pdf1 = conv_pdf(joint_cci_pdf,sci_pdf);

elseif param.thru~=0 & xtk==0 % must be only thru only
    joint_pdf =sci_pdf;
%    joint_pdf1 = sci_pdf;

    
elseif param.thru==0 & xtk~=0 % must be xlk only
    joint_pdf = joint_cci_pdf;
end
if xtk~=0
    cci_mxi=find(cumsum(joint_cci_pdf.y) >=param.specBER,1,'first');
    crosstalk_max_peak_interferance_at_BER=joint_cci_pdf.x(cci_mxi);
    cci_msi=find(cumsum(joint_cci_pdf.y) >=1e-12,1,'first');
    cci_sigma=abs(joint_cci_pdf.x(cci_msi)/(erfcinv(2*1e-12)*sqrt(2)));
    if exist('MDNEXT_cci_pdf','var')
        mdnxi=find(cumsum(MDNEXT_cci_pdf.y) >=param.specBER,1,'first');
        MDNEXT_peak_interference=abs(MDNEXT_cci_pdf.x(mdnxi));
    end
    if exist('MDFEXT_cci_pdf','var')
        mdfxi=find(cumsum(MDFEXT_cci_pdf.y) >=param.specBER,1,'first');
        MDFEXT_peak_interference=abs(MDFEXT_cci_pdf.x(mdfxi));
    end 
    
end
if param.thru~=0
    sci_mxi=find(cumsum(sci_pdf.y) >=param.specBER,1,'first');
    thru_max_peak_interferance_at_BER=abs(sci_pdf.x(sci_mxi));
    sci_msi=find(cumsum(sci_pdf.y) >=1e-12,1,'first');
    sci_sigma=abs(sci_pdf.x(sci_msi)/(erfcinv(2*1e-12)*sqrt(2)));
end
mxi=find(cumsum(joint_pdf.y) >=param.specBER,1,'first');
max_peak_interference_at_BER=abs(joint_pdf.x(mxi));
msi=find(cumsum(joint_pdf.y) >=1e-12,1,'first');
% noise_sigma=abs(joint_pdf.x(msi)/(erfcinv(2*1e-12)*sqrt(2)));
max_peak_interference=abs(joint_pdf.x(msi));
% now do for cci and sci
if xtk~=0
    cci_mxi=find(cumsum(joint_cci_pdf.y) >=param.specBER,1,'first');
    crosstalk_max_peak_interferance_at_BER=abs(joint_cci_pdf.x(cci_mxi));
end
%% combine device budget with channel peak operating margin (COM)
% param.Na_rms;

Na_noise = normal_dist(param.Na_rms,7.5,joint_pdf.BinSize);

% signal dependant noise 
sig_depend_noise = normal_dist(param.G_s_noise*param.AG*max_signal,7.5,joint_pdf.BinSize);

norm_noise_terms=conv_fct(Na_noise,sig_depend_noise);

ddmin=param.G_dd_noise*param.AG*max_signal;
dd_noise_values=[-ddmin ddmin ];
prob= [.5 .5];

dd_noise=d_cpdf(joint_pdf.BinSize,dd_noise_values, prob);

end_noise_terms=conv_fct(norm_noise_terms,dd_noise);


peak_system_interference=conv_fct(joint_pdf,end_noise_terms);
cdf=cumsum(peak_system_interference.y); % determine cumulative probability
sirix= find(cdf>param.specBER,1,'first');

%sirix= find(peak_system_interference.y>param.specBER,1,'first');
jpdfix=find(cumsum(joint_pdf.y) >param.specBER,1,'first');

%% reporting
if exist('max_signal','var') ,
    output_args.channel_operating_margin_dB=20*log10(param.AG*max_signal/abs(peak_system_interference.x(sirix)));
end
output_args.peak_interference_mV=1000*abs(peak_system_interference.x(sirix));
output_args.peak_channel_interference_mV=1000*abs(joint_pdf.x(jpdfix));
if exist('thru_max_peak_interferance_at_BER','var'), output_args.peak_ISI_mV=1000*thru_max_peak_interferance_at_BER;end
if exist('crosstalk_max_peak_interferance_at_BER','var'), output_args.peak_MDXTK_interference_mV=1000*crosstalk_max_peak_interferance_at_BER;end
if ICN ~= 0, 
    output_args.icn_mV=ICN*1000; 
end
if exist('MDNEXT_peak_interference','var'), output_args.peak_MDNEXT_interference_mV=1000*MDNEXT_peak_interference; end
if exist('MDFEXT_peak_interference','var'), output_args.peak_MDFEXT_interference_mV=1000*MDFEXT_peak_interference; end
if exist('max_signal','var'),
    output_args.available_signal_after_eq_mV=1000*param.AG*max_signal;
    if OP.GET_FD ~=0 ,
        output_args.fit_loss_dB_at_Fnq = fit_loss;
        output_args.IL_dB_at_Fnq=Nq_loss;
        output_args.baud_rate_GHz=param.fb/1e9;
        output_args.ILD_RMS=ILD_RMS;
    end
end
%%
if OP.DEBUG
    figure(600)
    semilogy(joint_pdf.x,joint_pdf.y,'r','Disp','joint PDF')
    hold on
    semilogy(end_noise_terms.x,end_noise_terms.y,'c','Disp','device noise')
    semilogy(peak_system_interference.x,peak_system_interference.y,'k','Disp','device and JOINT peak noise')
    
    ylim([1e-12 1])
    ylabel('Probability (log10)')
    xlabel('volts')
    title(regexprep([chdata(1).base,' Set Joint  test adding noise PDF'],'_',' '))
    if param.thru~=0
        display(['max noise at BER = ' num2str(max_peak_interference_at_BER)])
        display(['max signal after eq = ' num2str(param.AG*max_signal)])
    end
end
% create mat file with result
if OP.DISPLAY_WINDOW
    if output_args.channel_operating_margin_dB >= param.cc1
        h = msgbox(['PASS ... margin = ' num2str(output_args.channel_operating_margin_dB) 'dB']); set(h,'Color','g');
        
    else
        h = msgbox(['FAIL ... margin = ' num2str(output_args.channel_operating_margin_dB) 'dB']); set(h,'Color','r');
    end
end

if OP.DEBUG
    if param.thru
        if OP.GET_FD ~=0, output_args.equivalent_ISI_ICN=sci_sigma; end
        output_args.ctle_zero_poles_acdcgaindB=[-result.eq.ctle.zero/(2*pi) -result.eq.ctle.pole2/(2*pi) -result.eq.ctle.pole1/(2*pi)];
        output_args.acdcgaindB=20*log10(result.eq.ctle.maxkacdc);
        output_args.txle_taps=result.eq.txle;
    end
    if param.thru
       if OP.GET_FD ~=0, output_args.sci_noise_FD_RMS=FD_rms_sci;end
    end
    if xtk~=0
        output_args.cci_noise_TD_BER=crosstalk_max_peak_interferance_at_BER;
        output_args.equivalent_ISI_ICN=cci_sigma;
    end
    if param.thru
        output_args.max_peak_interference_at_BER=max_peak_interference_at_BER;
        output_args.raw_equalizer_SNR =result.best_SNR_ISI;
    end
end

%% making mat file

if OP.EXTERNAL== false,
    output_args.file_names=str2mat(chdata.base);
    display( ['Files set is: ' chdata(1).base]);
    if(OP.DEBUG), save ([chdata(1).base '_results.mat'],'output_args');end
else
    output_args.txle_pre=result.eq.txle(1);
    output_args.txle_cursor=result.eq.txle(2);
    output_args.txle_post=result.eq.txle(3)
    output_args.NA_rms=param.Na_rms;
    output_args.G_s_noise=param.G_s_noise;
    output_args.G_dd_noise=param.G_dd_noise;
end

%% makeing csv file
if OP.CSV_REPORT ==1
    ihead=1;
    header(ihead,:)={'File set'};
    data(ihead)={chdata(1).base};
    ihead=ihead+1;
    if exist('max_signal','var') ,
        header(ihead,:)={'COM_dB'};
        data(1,ihead)={output_args.channel_operating_margin_dB};
        ihead=ihead+1;
    end
    header(ihead,:)={'peak_interference_mV'};
    data(ihead)={output_args.peak_interference_mV};
    ihead=ihead+1;    
    header(ihead,:)={'peak_channel_interference_mV'};
    data(ihead)={output_args.peak_channel_interference_mV};
    ihead=ihead+1;     
    if exist('thru_max_peak_interferance_at_BER','var'),
        header(ihead,:)={'peak_ISI_mV'};
        data(1,ihead)={output_args.peak_ISI_mV};
        ihead=ihead+1;
    end
    if exist('crosstalk_max_peak_interferance_at_BER','var'),
        header(ihead,:)={'peak_MDXTK_interference_mV'};
        data(1,ihead)={output_args.peak_MDXTK_interference_mV};
        ihead=ihead+1;
    end
    if ICN ~= 0, 
        header(ihead,:)={'ICN'};
        data(1,ihead)={output_args.icn_mV};
        ihead=ihead+1;
    end
    if exist('MDNEXT_peak_interference','var'),
        header(ihead,:)={'peak_MDNEXT_interference_mV'};
        data(1,ihead)={output_args.peak_MDNEXT_interference_mV};
        ihead=ihead+1;
    else
        header(ihead,:)={'peak_MDNEXT_interference_mV'};
        data(1,ihead)={0};
        ihead=ihead+1;  
    end
    if exist('MDFEXT_peak_interference','var'),
        header(ihead,:)={'peak_MDFEXT_interference_mV'};
        data(1,ihead)={output_args.peak_MDFEXT_interference_mV};
        ihead=ihead+1; 
    else
        header(ihead,:)={'peak_MDFEXT_interference_mV'};
        data(1,ihead)={0};
        ihead=ihead+1;      
    end
    if exist('max_signal','var') ,
        if OP.GET_FD ~=0 ,
            header(ihead,:)={'fit_loss_dB_at_Fnq'};
            data(1,ihead)={output_args.fit_loss_dB_at_Fnq};
            ihead=ihead+1;
            header(ihead,:)={'IL_loss_dB_at_Fnq'};
            data(1,ihead)={output_args.IL_dB_at_Fnq};
            ihead=ihead+1;
            header(ihead,:)={'ILD RMS'};         
            data(1,ihead)={output_args.ILD_RMS};
            ihead=ihead+1;
        end
        header(ihead,:)={'available_signal_after_eq_mV'};
        data(1,ihead)={output_args.available_signal_after_eq_mV};
        ihead=ihead+1;
    end
    header(ihead,:)={'coding'};
    ihead=ihead+1;
    header(ihead,:)={'Fnq (GHz)'};
    data(1,ihead)={1/param.ui/2};
    ihead=ihead+1;
    header_string=header(1);
    for i = 2:length(header)
        header_string = strcat(header_string, ',' ,header(i));
    end
    if OP.EXTERNAL== false
        fid = fopen([OP.RESULT_DIR chdata(1).base '_results.csv'],'w');
        fprintf(fid,'%s\r\n',cell2mat(header_string));
        fprintf(fid,'%s,',cell2mat(data(1)));
        for i=2:length(header)-2
            fprintf(fid,'%f,',cell2mat(data(i)));
        end
        fprintf(fid,'%s,',cell2mat({param.coding}));
        fprintf(fid,'%f,',cell2mat({1/param.ui/2/1e9}));
        for i=2:nxi
            fprintf(fid,'%s,',cell2mat({chdata(i).base}));
        end
        
        fclose(fid);
    end
end

%%
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
function [voltage, t_base] =s21_to_impulse_DC(IL, freq_array, time_step)
% 3/23/2012 
% Creates a time-domain impulse response from frequency-domain IL data.
% IL does not need to have DC but a corresponding frequency array
% (freq_array) is required.
%
% Causality is imposed using the Alterating Projections Method. See also:
% Quatieri and Oppenheim, "Iterative Techniques for Minimum Phase Signal 
% Reconstruction from Phase or Magnitude", IEEE Trans. ASSP-29, December
% 1981 (http://ieeexplore.ieee.org/xpls/abs_all.jsp?arnumber=1163714)
% $Id: IL2FIR.m.rca 1.16 Tue Feb 28 15:47:42 2012 aran Experimental $
rel_tol = 1e-3;
diff_tol = 1e-4;
causality_tol = 0.05;
% spline fit to DC , rim 3-23-2012
ILin=IL;
fmax=1/time_step/2;
freq_step=(freq_array(3)-freq_array(2))/1;
fout=0:1/round(fmax/freq_step)*fmax:fmax;
IL=interp_Sparam(ILin,freq_array,fout);
IL = IL(:); 
% add padding for time steps
IL_symmetric = [IL(1:end-1);0; flipud(conj(IL(2:end-1)))];
fir = real(ifft(IL_symmetric));
% Correct non-causal effects frequently caused by extrapolation of IL
abs_fir=abs(fir);
a = find(abs_fir>max(abs_fir)*causality_tol);
start_ind = a(1);
err=inf;
% figure(1000)
 t_base = (0:length(fir)-1)/(freq_step*length(fir));
% UI_ones(1:32)=1;
% pulse=filter(UI_ones,1,fir);
% figure
% plot(t_base,pulse);
% hold on
while 1
    fir(floor(length(fir)/2):end)=0;
    fir(1:start_ind)=0;
    IL_modified=abs(IL_symmetric).*exp(1j*angle(fft(fir)));
    fir_modified = real(ifft(IL_modified));
    delta = abs(fir-fir_modified);

    err_prev = err;
    err=max(delta)/max(fir);
    if (err<rel_tol) | (err_prev-err<diff_tol) 
        break;
    end
 
    fir=fir_modified;
end
% t_base = (0:length(fir)-1)/(freq_step*length(fir));
% UI_ones(1:32)=1;
% pulse=filter(UI_ones,1,fir);
% plot(t_base,pulse,'r');
% hold off
voltage = fir;

function [Sout] = interp_Sparam(Sin,fin,fout)
% Sout = interp_Sparam(Sin,fin,fout)
%
% Interpolate S-parameters Sin from frequency grid fin to frequency grid
% fout.
% fout is assumed to begin at 0 (DC), and zero phase is enforced (see
% source for options).
% Extrapolation to higher frequencies is done using the last available
% frequency data (without fitting the trend). This is not exactly
% physical, but typically happens only at very high frequencies where
% IL is low - so for IL the error is small. RL at high frequencies may not
% be reliably extrapolated.
%
% Based on old code originally by Boris Fakterman.

% $Id: interp_Sparam.m.rca 1.15 Thu Mar 22 12:44:57 2012 aran Experimental $

if ( fin(end)<fout(end) )
%    warning('Channel high frequencies extrapolation might be innacurate!');
end

global opt_interp_Sparam_phase opt_interp_Sparam_mag
defval ('opt_interp_Sparam_mag', 'linear_trend_to_DC');
defval ('opt_interp_Sparam_phase', 'trend_and_shift_to_DC');

H_mag = abs(Sin);
H_mag(H_mag<eps)=eps; % handle ill cases...
H_ph = unwrap(angle(Sin));

switch opt_interp_Sparam_mag
    case 'linear_trend_to_DC'
        fin_x=fin;
        H_mag_x=H_mag(:);
        if fin(1)>0
            p=polyfit(fin(1:10), H_mag(1:10), 1);
            dc_trend_val=polyval(p, 0);
            fin_x=[0, fin_x];
            H_mag_x = [dc_trend_val; H_mag_x];
        end
        if fin(end)<fout(end)
            warn_state=warning('off', 'MATLAB:polyfit:RepeatedPointsOrRescale');
            mid_freq_ind=round(length(fin)/2);
            p=polyfit(fin(mid_freq_ind:end), H_mag(mid_freq_ind:end), 1);
            warning(warn_state);
            hf_trend_val=polyval(p, fout(end));
            if hf_trend_val>H_mag(end)
                hf_trend_val=H_mag(end);
            elseif hf_trend_val<eps
                hf_trend_val=eps;
            end
            fin_x=[fin_x, fout(end)];
            H_mag_x = [H_mag_x; hf_trend_val];
        end
        H_mag_i = interp1(fin_x, H_mag_x, fout, 'linear', 0);
    case 'trend_to_DC'
        % extrapolate to trend value at DC.
        fin_x=fin;
        H_mag_x=H_mag;
        if fin(1)>0
            p=polyfit(fin(1:10)', log10(H_mag(1:10)), 1);
            dc_trend_val=10^polyval(p, 0);
            fin_x=[0, fin_x];
            H_mag_x = [dc_trend_val; H_mag_x];
        end
        if fin(end)<fout(end)
            warn_state=warning('off', 'MATLAB:polyfit:RepeatedPointsOrRescale');
            mid_freq_ind=round(length(fin)/2);
            p=polyfit(fin(mid_freq_ind:end)', log10(H_mag(mid_freq_ind:end)), 1);
            warning(warn_state);
            hf_trend_val=10^polyval(p, fout(end));
            if hf_trend_val>H_mag(end)
                hf_trend_val=H_mag(end);
            end
            fin_x=[fin_x, fout(end)];
            H_mag_x = [H_mag_x; hf_trend_val];
        end
        H_mag_i = 10.^interp1(fin_x,log10(H_mag_x),fout,'linear', 'extrap');
    case 'extrap_to_DC_or_zero'
        % same as extrap_to_DC but detect AC-coupled channels and
        % extrapolate them to 0.
        if fin(1)>0 && 20*log10(H_mag(1))<-20
            % assume AC coupling, with 0 at DC
            H_mag_i = 10.^interp1([0, fin],[-100; log10(H_mag)],fout(fout<=fin(end)),'linear', 'extrap');
        else
            H_mag_i = 10.^interp1(fin, log10(H_mag), fout(fout<=fin(end)),'linear', 'extrap');
        end
        H_mag_i(fout>fin(end)) = H_mag(end);
	case 'extrap_to_DC'
		% first extrapolate down to DC, then use highest available frequency
		% for higher frequencies
		H_mag_i = 10.^interp1(fin,log10(H_mag),fout(fout<=fin(end)),'linear', 'extrap');
		H_mag_i(fout>fin(end)) = H_mag(end);
	case 'old'
		H_mag_i = interp1(fin,H_mag,fout,'linear','extrap');
	otherwise
		warning('opt_interp_Sparam_mag valid values are "old", "extrap_to_DC"');
end

H_ph_i = interp1(fin,H_ph,fout,'linear', 0);

switch opt_interp_Sparam_phase
	case 'old'
		H_ph_i = H_ph_i-H_ph_i(1);
	case 'zero_DC'
		H_ph_i(1) = 0;
	case 'interp_to_DC'
        if fin(1) ~= 0
			H_ph_i = interp1([0; fin(:)], [0; H_ph(:)], fout, 'linear', 'extrap');
        end
    case 'interp_and_shift_to_DC'
        if fin(1) ~= 0
            dc_phase_trend = H_ph(1)-(H_ph(2)-H_ph(1))/(fin(2)-fin(1))*fin(1);
			H_ph_i = interp1([0; fin(:)], [0; H_ph(:)-dc_phase_trend], fout, 'linear', 'extrap');
        end
    case 'trend_and_shift_to_DC'
        % estimate low frequency group delay
        group_delay = -diff(H_ph(:))./diff(fin(:));
        low_freq_gd = group_delay(1:50);
        %  calculate trend, throwing away outliers
        m = median(low_freq_gd); sigma = std(low_freq_gd);
        lf_trend = mean(low_freq_gd(abs(low_freq_gd-m)<sigma));
        % correct outliers in first 10 phase samples
        for k=10:-1:1
            H_ph(k) = H_ph(k+1) + lf_trend*(fin(k+1)-fin(k));
        end
        fin_x=fin;
        H_ph_x=H_ph(:);
        % shift all phase data so that DC extrapolation to 0 follows trend
        if fin(1) ~= 0
            dc_phase_trend = H_ph(1)+lf_trend*(fin(1)-0);
            fin_x=[0, fin_x];
            H_ph_x=[0; H_ph(:)-dc_phase_trend];
        end
        % Modification: extrapolate using trend. (interp1 with "extrap" extrapolates using just
        % the last two samples, so noise can create an inverted slope and
        % non-causal response).
        if fout(end)>fin(end)
            group_delay = -diff(H_ph_x(:))./diff(fin_x(:));
            % p=polyfit(fin_x', H_ph_x, 1);
            hf_phase_trend = H_ph_x(end)-median(group_delay)*(max(fout)-max(fin_x));
            % hf_phase_trend=polyval(p,max(fout));
            fin_x=[fin_x, fout(end)];
            H_ph_x=[H_ph_x; hf_phase_trend];
        end
		H_ph_i = interp1(fin_x, H_ph_x, fout, 'linear', 'extrap');
        
	otherwise
		warning('debug_interp_Sparam valid values are "old", "zero_DC", "interp_to_DC", "interp_and_shift_to_DC"');
end
H_i = H_mag_i.*exp(1j*H_ph_i);
Sout=H_i;

function [data, SDD, SDC] = read_p4_s4params(infile, plot_ini_s_params, plot_dif_s_params, ports)
%% FUNCTION :: read_sp4_sparams
%
% Description
%   Read the fid of single-ended 4-port complex S-parameters
%   in Touchstone format 'file' and convert to the internal
%   format using the port transform 'ports'
%
%   Created by Mike Y. He
%   April 22, 2005
%
%   Reused some code from
%   Anthony Sanders, Alex Deas, Bob Davidov (24 January 2005)
%   for touchstone 4-port S-matrix import.
%
%   Modified (2012-July-27) by Ken Young to match current indexing scheme and
%   optimized for quicker parameter matching and parsing. also, separated out
%   the plotting algorithms into their own sub-function routines
%
% Input Variables (required)
%   file                -- The s4p file to be read and coverted
%   plot_ini_sparams    -- Plot the initial s-parameter information. For debugging purposes
%   plot_diff_sparams   -- Plot the differential s-parameter information. For debugging purposes
%   swap                -- Re-order the port layout
%
% Output/Return Variables
%   sch         -- the data matrix contain the network parameter data points 
%   schFreq     -- the frequency vector of the network parameter data points
%   sdc         -- the differential in/common-mode out s-parameter data matrix
%   sdd         -- the differential in/differential out s-parameter data matrix
%
% Local Variables (scoped locally to current function only)
%   fid                 -- the opened file being processed
%   fileDataLine        -- the current line in the fid
%   optionLine          -- the options line in the s4p file
%   ports               -- the order of the ports being processed
%   idxNetParams        -- the position (line) of the network parameter data points in the s4p file
%   netParamDataPoints  -- the network parameter data points of the current line of the fid
%   schFreq             -- the frequency points in the s4p file stored as a separate vector
%   sch                 -- the network parameter data points from the s4p file converted in matrix form 
%   S                   --
%   T                   --
%   W                   --
%   D                   --
%   sdd                 -- the differential in/differential out form of network parameter data points
%   sdc                 -- the differential in/common-mode out form of network parameter data points
%   plot_ini_sparams    -- Plot the initial s-parameter information. For debugging purposes
%   plot_diff_sparams   -- Plot the differential s-parameter information. For debugging purposes
%
    
    % open the fid
    fid = fopen(infile, 'r');

    data_file = textscan(fid, '%s', 'delimiter', sprintf('\n'));
    data_file = data_file{1,1}; % removes a dimension layer of cell array depth

    fclose(fid);
    
    % backwards compatibility settings. can be removed in updated code.
    if ~exist('OP', 'var'); OP.DISPLAY_WINDOW = true; end
    if isempty(ports); ports = [1 3 2 4]; end % default order normally used.
    
    if OP.DISPLAY_WINDOW
        set(0,'defaulttextinterpreter','none') % prevents subscripting character in displayed messages
        hMsgBox = msgbox(infile, 'Reading S-Sparameter File'); % display a progress bar for reading the s-parameter file(s)
    end
    
    % parse the file array until the s-paramters options line is found
    idxLine = 1;
    while true
        if regexp(data_file{idxLine}, '^#', 'once')
            % tests the option fileDataLine cell array to see if it contains...
            if ~isempty(regexpi(data_file{idxLine}, '\sGHz')); freq_scale = 1e9; end
            if ~isempty(regexpi(data_file{idxLine}, '\sMHz')); freq_scale = 1e6; end
            if ~isempty(regexpi(data_file{idxLine}, '\sKHz')); freq_scale = 1e3; end
            if ~isempty(regexpi(data_file{idxLine}, '\sHz'));  freq_scale = 1e0; end
            if ~isempty(regexpi(data_file{idxLine}, 'RI')) && ~isempty(regexpi(data_file{idxLine}, 'R'))
                format = 'complex';
            end
            if ~isempty(regexpi(data_file{idxLine}, 'MA')) && ~isempty(regexpi(data_file{idxLine}, 'R'))
                format = 'linpolar';
            end
            if ~isempty(regexpi(data_file{idxLine}, 'DB')) && ~isempty(regexpi(data_file{idxLine}, 'R'))
                format = 'dBpolar';
            end
            
            % if the format or freq_scale are not set then exit with error
            if isempty(freq_scale)
                error( 'warningMissingOptionsParameter', ['\n\t THE FREQUENCY SCALE PARAMETER INFORMATION IS MISSING' ...
                    'FROM THE OPTIONS LINE IN THE S4P FILE']);
            elseif isempty(format)
                error( 'warningMissingOptionsParameter', ['\n\t THE FORMAT PARAMETER INFORMATION IS MISSING' ...
                    'FROM THE OPTIONS LINE IN THE S4P FILE']);
            end
            
            idxLine = idxLine+1; %step one more line before exiting loop
            break
        end
        idxLine = idxLine+1;
    end
        
    col_1=1; col_2=2; col_3=3; col_4=4; % This is to maintain current indexing compatibility as well as readability
    schFreqAxis = zeros(1,int8((length(data_file)-idxLine)/4)); % preallocated array length for memory and time purposes
    idxNetParams = 1; % each 4-port network parameter data point set will receive an index
    while true
        if isempty(data_file{idxLine}) || ~isempty(regexp(data_file{idxLine}, '^!', 'once'))
            idxLine = idxLine+1;
        else
            for row=1:4
                tmp = textscan(data_file{idxLine}, '%f' , 'MultipleDelimsAsOne', ' ');
                dataPointsLine = tmp{1,1}; % removes a dimension layer of cell array depth
                if mod(length(dataPointsLine),8)==1
                    schFreqAxis(idxNetParams) = dataPointsLine(1) * freq_scale;
                    dataPointsLine(1) = []; % removes the frequency value from the current data fileDataLine cell array
                                            % so that only the network parameter data is in the array
                end
                if mod(length(dataPointsLine),8)~=0  % sanity check to make sure the network parameter data point line structure is correct
                    msg = sprintf(['\n'...
                       '\n\t ******************************************************' ...
                       '\n\t ** There is an error in the s4p network parameter   **' ...
                       '\n\t ** data point information structure at line %G.'        ...
                       '\n\t **              ENDING PROGRAM                      **' ...
                       '\n\t ******************************************************' ...
                       '\n\n\n\t Press any key to exit (an error will be displayed). \n\n']);
                    disp(msg)
                    pause on;
                    pause;
                    pause off;
                    error( 'warning:SparamFileDataError', '\n\t INCORRECT S4P NETWORK PARAMETER DATA POINT STRUCTURE');
                else
                    switch format
                        case 'complex'
                            sch(idxNetParams, ports(row), ports(col_1)) = dataPointsLine(1) + 1i*dataPointsLine(2);
                            sch(idxNetParams, ports(row), ports(col_2)) = dataPointsLine(3) + 1i*dataPointsLine(4);
                            sch(idxNetParams, ports(row), ports(col_3)) = dataPointsLine(5) + 1i*dataPointsLine(6);
                            sch(idxNetParams, ports(row), ports(col_4)) = dataPointsLine(7) + 1i*dataPointsLine(8);
                        case 'linpolar'
                            sch(idxNetParams, ports(row), ports(col_1)) = dataPointsLine(1) * exp(1i*dataPointsLine(2)*(pi/180));
                            sch(idxNetParams, ports(row), ports(col_2)) = dataPointsLine(3) * exp(1i*dataPointsLine(4)*(pi/180));
                            sch(idxNetParams, ports(row), ports(col_3)) = dataPointsLine(5) * exp(1i*dataPointsLine(6)*(pi/180));
                            sch(idxNetParams, ports(row), ports(col_4)) = dataPointsLine(7) * exp(1i*dataPointsLine(8)*(pi/180));
                        case 'dBpolar'
                            sch(idxNetParams, ports(row), ports(col_1)) = 10^(dataPointsLine(1)/20) * exp(1i*dataPointsLine(2)*(pi/180));
                            sch(idxNetParams, ports(row), ports(col_2)) = 10^(dataPointsLine(3)/20) * exp(1i*dataPointsLine(4)*(pi/180));
                            sch(idxNetParams, ports(row), ports(col_3)) = 10^(dataPointsLine(5)/20) * exp(1i*dataPointsLine(6)*(pi/180));
                            sch(idxNetParams, ports(row), ports(col_4)) = 10^(dataPointsLine(7)/20) * exp(1i*dataPointsLine(8)*(pi/180));
                        otherwise
                    end
                end
                idxLine = idxLine+1;
            end
            idxNetParams = idxNetParams + 1;
        end
        if idxLine > length(data_file)
            break
        end
    end

    % calculate differential s parameter matrix from single ended
    for i=1:size(sch,1)
        S(:,:) = sch(i,:,:);
        T = [1 1 0 0 ; 1 -1 0 0 ; 0 0 1 1 ; 0 0 1 -1];
        W = T * (S / T);
        D(i,:,:) = W(:,:);
    end

    % D matrix should be
    % Scc11 Scd11 Scc12 Scd21
    % Sdc11 Sdd11 Sdc12 Sdd12
    % Scc21 Scd21 Scc22 Scd22
    % Sdc21 Sdd21 Sdc22 Sdd22

    % proper values
    sdd(:,1,1) = D(:,2,2);
    sdd(:,2,2) = D(:,4,4);
    sdd(:,1,2) = D(:,2,4);
    sdd(:,2,1) = D(:,4,2);

    sdc(:,1,1) = D(:,2,1);
    sdc(:,2,2) = D(:,4,3);
    sdc(:,1,2) = D(:,2,3);
    sdc(:,2,1) = D(:,4,1);
    
    
    if (plot_ini_s_params == 1)
        figure    
        for mj=1:4
            legendIndex=1;   
            for mi=1:4
                subplot(2,2,mj);
                plot(data.f, 20*log10(abs(data.m(:,mj,mi)+1.0e-15)), c(mj,mi), 'linewidth',2); hold on 
                legendTitle(legendIndex,1:3) = sprintf('S%d%d', mj, mi);
                legendIndex=legendIndex+1;
            end
            xlabel('Frequency (Hz)');
            ylabel('Magnitude (dB)');
            legend(legendTitle,3);
            grid on
            title(infile);
        end
    end

    if (plot_dif_s_params == 1)
        figure    
        subplot(2,1,1);
        legendIndex=1;   
        for mj=1:2
            for mi=1:2
                plot(data.f, 20*log10(abs(SDD(:,mj,mi))), c(1, (mj-1)*2+mi), 'linewidth',2); hold on 
                legendTitle(legendIndex, 1:5) = sprintf('SDD%d%d', mj, mi);
                legendIndex=legendIndex+1;
            end
        end
        xlabel('Frequency (Hz)');
        ylabel('Magnitude (dB)');
        legend(legendTitle,3);
        grid on
        title(infile);

        subplot(2,1,2);
        legendIndex=1;   
        for mj=1:2
            for mi=1:2
                plot(data.f, 20*log10(abs(SDC(:,mj,mi))+1.0e-15), c(1, (mj-1)*2+mi), 'linewidth',2); hold on 
                legendTitle(legendIndex,1:5) = sprintf('SDC%d%d', mj, mi);
                legendIndex=legendIndex+1;
            end
        end
        xlabel('Frequency (Hz)');
        ylabel('Magnitude (dB)');
        legend(legendTitle,3);
        grid on

    end
    
    
    if OP.DISPLAY_WINDOW; close(hMsgBox); end
    % backwards compatibility output variables
    data.m = sch;
    data.freq = schFreqAxis;
    SDC = sdc;
    SDD = sdd;
% end read_sp4_sparam
function result = readdataSnPx(filename, nport)
            %function [freq, cs] = readdataSnPx(filename, nport)
            % [freq, cs] = readdataSnP(filename, nport, format, nheader)
            %
            % Read Touchstone file with frequencies in units of Hertz
            %
            % Input:
            % ======
            % filename: Name of the Touchstone/SnP file
            % nport: Number of ports
            % format: 'RI' for real/imag, 'MA' for mag/angle (check option line in the
            %         Touchstone file)
            % nheader: Number of header lines (comment lines plus option line in the 
            %          Touchstone file)
            % 
            % Output:
            % =======
            % freq: Vector of frequencies [Hz]
            % cs: 3-D array of complex-valued S parameters where cs(i,j,k) is S(i,j) 
            %     at frequency freq(k)
            %
            % Note: If frequency unit is not Hertz (but GHz, MHz etc.) simply scale
            % frequencies appropriately after reading the data.
            %
            % Ref.: Touchstone(R) File Format Specification, Rev.1.1, 
            % EIA/IBIS Open Forum, 2002.
            %
            % Written by Henning Braunisch, September 2004.
            % Updated by Steven Krooswyk, April 2006.  


            fid = fopen(filename, 'r');


            % Skip header lines
            str = ' ';
            n = 0;
            while ~strcmp(str(1),'#')
                str = fgetl(fid);
                if length(str) == 0 
                    str=' ' ;
                    if n > 1000 
                        display('error: could not find config line (#)')
                        break
                    end
                end
                n = n + 1;
            end

            % parse configuration line 
            A=sscanf(str,'%1s %2s %1s %2s %1s %2s',[1,inf]);
            p = find(A=='S');           %position of 'S'
            units = lower(A(2:p-1));    %units before 'S'
            format = A(p+1:p+2);        %format after 'S'

            % skip any more header lines
            %while ~str

            nk = 0; % frequency counter
            while 1==1

                [temp, count] = fscanf(fid, '%f', 1);
                if count == 0
                    [temp2, count2] = fscanf(fid, '%s', 1);     
                    if length(temp2)>0, fgetl(fid); continue, end;
                    break 
                end
                nk = nk+1; freq(1,nk) = temp;
                for ni = 1:nport
                    for nj = 1:nport
                        if lower(format) == 'ma' 
                            mag = fscanf(fid, '%f', 1); ang = fscanf(fid, '%f', 1); 
                            cs(ni,nj,nk) = mag * exp(j*ang*pi/180);
                        elseif lower(format) == 'ri'
                            re = fscanf(fid, '%f', 1); im = fscanf(fid, '%f', 1); 
                            cs(ni,nj,nk) = re + j*im;
                        elseif lower(format) == 'db'
                            db = fscanf(fid, '%f', 1); ang = fscanf(fid, '%f', 1);
                            M = 10^(db/20);
                            %re = M*cos(ang);
                            %im = M*sin(ang);
                            re =  M*cos(ang * pi / 180);
                            im =  M*sin(ang * pi / 180);
                            cs(ni,nj,nk) = re + j*im;
                        else
                            error('readdataSnP: Unknown data format');
                        end  
                    end
                end
            end

            fclose(fid);

            % If 2-port then swap S_12 and S_21 per Touchstone spec
            if nport == 2
                temp = cs(2,1,:);
                cs(2,1,:) = cs(1,2,:);
                cs(1,2,:) = temp;
            end

            % Update freq units to Hz 
            switch lower(units)
                case 'hz'

                case 'khz'
                    freq=freq.*1e3;
                case 'mhz'
                    freq=freq.*1e6;
                case 'ghz'
                    freq=freq.*1e9;
            end
            
            % passivity check
            
            
            result.freq = freq;
            result.cs    = cs;
     
function result = reduce(var1)
% --- Reduce 1x1xn array to 1xn
    out = zeros(1,length(var1));
    out(1,:) = var1(1,1,:);    
    result=out;
% end % reduce

function result=get_BR(ir,t_base,samp_UI)
%ir = impulse response
%t_base=time array with equal time steps
%samp_UI = number of samples per UI for ir
%   result.SBR
%   result.DBR
UI_ones(1:samp_UI)=1;
%pulse=conv(ir,UI_ones);
pulse=filter(UI_ones,1,ir);
result.SBR=pulse;
DBR=[];
ideal_dibit(1:samp_UI)=1;
ideal_dibit(samp_UI+1:2*samp_UI)=-1;
result.DBR=filter(ideal_dibit,1,ir);

function [pdf]=get_pdf(max_signal, excluded_UI, i, chdata, param, OP) 
        index=i;
        SBR=chdata(i).result.SBR;
        type=chdata(i).type;
        max_sig=max_signal;
        t_base=chdata(i).t;
        UI=param.ui;
        samp_UI=param.samples_per_ui;
        debug=OP.DEBUG;
        name=chdata(i).base;
        if param.levels == 2 ; coding='NRZ' ; else coding='PAM4'; end        
% The assumption is that the SBR is fitered and equalized if a thru
% excluded_UI = 0 means crosstalk wave excluded_UI ~0 means we have a thru
step=UI/samp_UI;
% create new resampled time array
last_usable_t_index=length(t_base)-mod(length(t_base),samp_UI);
trs=t_base(1):step:t_base(last_usable_t_index);
% resample SBR ?? don't know if this step is needed anymore
SBR=interp1(t_base, SBR, trs);
% next determine region of interest
if excluded_UI ~=0
    main_cursor=find(SBR >= .999*max_sig,1,'first');
    SBR1=SBR;
    start_point=1;
                SBR1(main_cursor+param.samples_per_ui*(1):main_cursor+param.samples_per_ui*(param.ndfe+1))=...
                SBR(main_cursor+param.samples_per_ui*(1):main_cursor+param.samples_per_ui*(param.ndfe+1))-...
                sign(SBR(main_cursor+param.samples_per_ui*(1):main_cursor+param.samples_per_ui*(param.ndfe+1)))...
                .*min(param.maxcx*SBR(main_cursor),abs(SBR(main_cursor+param.samples_per_ui*(1):main_cursor+param.samples_per_ui*(param.ndfe+1))));
                SBR1(main_cursor+param.samples_per_ui*(-3):main_cursor+param.samples_per_ui*(1))=0;
                SBR=SBR1;
else
    start_point=1;
    main_cursor=1;
end


% t is the region of interest for v
t=trs(start_point):step:t_base(last_usable_t_index);
v=interp1(trs, SBR, t);
% at this point SBR contains all data to analyze
% resample fir each sample in each of nui's 
nui=round((max(t)-min(t))/UI)-5;
% the ts and vs are for each sample
% determine which value to use for pdf.
for i=1:samp_UI
    ts(1:nui,i)=t(samp_UI*(1:nui)+i);
    vs(1:nui,i)=v(samp_UI*(1:nui)+i);
end
hwaitbar=waitbar(0);

for i=1:samp_UI
   pdf_samples(i)=get_pdf_from_sampled_signal(vs(:,i),coding);
    mxV(i)=sqrt(sum( pdf_samples(i).x.^2.*pdf_samples(i).y)); % standard deviation of PDF
    progress = i/samp_UI;
    waitbar(progress, hwaitbar, 'find sampled pdf'); drawnow;
    if debug, 
        figure(250+index)
        semilogy(pdf_samples(i).x, pdf_samples(i).y,'disp',num2str(i) ); 
        hold on; 
        title(strrep(name,'_',' '))
    end 
end
close(hwaitbar)
% determine which pdf to use 
[na pxi]=max(mxV);
pdf=pdf_samples(pxi);

function [ILN, FIT]= get_ILN(sdd21,faxis_f2)
% used for FD IL fitting
% sdd21 us a complex insertion loss
fmbg=[ones(length(faxis_f2),1).*transpose(sdd21)  transpose(sqrt(faxis_f2)).*transpose(sdd21)  transpose(faxis_f2).*transpose(sdd21) transpose(faxis_f2.^2).*transpose(sdd21) ];
warning('off','MATLAB:nearlySingularMatrix');%display('ignore the following singularity warning that is expected')
unwraplog=log(abs(sdd21))+1i*unwrap(angle(sdd21));
LGw=transpose([sdd21.*unwraplog ]);
alpha = ((fmbg'*fmbg)^-1)*fmbg'*LGw;
efit=(alpha(1)+alpha(2).*sqrt(faxis_f2)+alpha(3).*faxis_f2 +faxis_f2.^2.*alpha(4)   );
FIT=transpose(exp(transpose(efit)));
ILN = sdd21-FIT;

function [sdd21p] = s21_pkg(sdd21, sdd11, sdd22, faxis, param, OP)
% conctenates packge reflections with s21,s11,and s22 with spec return loss (gammas)
% faxis is the frequncy array
% sdd21, sdd11, sdd22 are the corresponding array of differential
% parameters
gamma_tx=((param.G01-1i*faxis/(param.f1))./((1+1i*faxis/(param.f1))));
gamma_rx=-((param.G02-1i*faxis/(param.f2))./((1+1i*faxis/(param.f2))));
%sdd21p= sdd21./(1.- sdd11.*gamma_tx - sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx +sdd11.*sdd22.*gamma_tx.*gamma_rx);
%sdd21p= sdd21.*(1-gamma_tx).*(1+gamma_rx)./(1.- sdd11.*gamma_tx - sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx +sdd11.*sdd22.*gamma_tx.*gamma_rx);
if OP.INC_PACKAGE_RL==1
    sdd21p= sdd21./(1.- sdd11.*gamma_tx - sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx +sdd11.*sdd22.*gamma_tx.*gamma_rx);
elseif OP.INC_PACKAGE_RL==2
    sdd21p= sdd21.*(1-gamma_tx).*(1+gamma_rx)./(1.- sdd11.*gamma_tx - sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx +sdd11.*sdd22.*gamma_tx.*gamma_rx);
elseif OP.INC_PACKAGE_RL==3
    sdd21p= sdd21.*(1+gamma_rx)./(1.- sdd11.*gamma_tx - sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx +sdd11.*sdd22.*gamma_tx.*gamma_rx);
%     sdd21p= sdd21.*(1-gamma_rx)./(1.- sdd11.*gamma_tx + sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx -sdd11.*sdd22.*gamma_tx.*gamma_rx);
%     sdd21p= sdd21.*(1-gamma_rx).*(1+gamma_tx)./(1.- sdd11.*gamma_tx + sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx -sdd11.*sdd22.*gamma_tx.*gamma_rx);
elseif OP.INC_PACKAGE_RL==4
    sdd21p= sdd21.*(1-gamma_tx)./(1.- sdd11.*gamma_tx - sdd22.*gamma_rx  -sdd21.^2.*gamma_tx.*gamma_rx +sdd11.*sdd22.*gamma_tx.*gamma_rx);
else
    sdd21p= sdd21;
end


function defval(param, value)
% defval(VARIABLE_NAME, VALUE)
%
% Assign a default value for a variable.
%
% If VARIABLE_NAME does not exist in the current scope or is empty
% (string/array/cell array), it will be assigned to VALUE.
% Otherwise, it will remain unchanged.
%
% defval is useful for providing default values to optional function
% parameters.
%
% Note that VARIABLE_NAME is a string, so it should ususally be quoted.
% $Id: defval.m.rca 1.1 Mon Sep 21 15:12:22 2009 aran Experimental $

if ~evalin('caller', ['exist(''' param ''', ''var'')'])...
		|| isempty(evalin('caller', param))
	assignin('caller', param, value);
end
function result=sweep_eq(ir_in, OP, param)    
    %% input
% ir_in - impulse response
% baud_rate - baud rate in seconds
% param.samples_per_ui = samples per UI of IR
%  param.max_ctle - maximum ac to dc gain in dB
% param.tx_ffe(1) - maximum pre cursor (positive value)
% param.tx_ffe(2) - maximum post cursor (positive value)
% param.tx_ffe_step - sweep step size for tx pre and post taps
% param.ndfe - number of reference dfe taps
% output
% result.eq.txle - [ precusor curosr postcursor]: pre and post are negative
% result.eq.ctle.zero - Frequency of zero (HZ)
% result.eq.ctle.pole1- Frequency of pole (HZ)
% result.eq.ctle.pole2- -infinity
% result.eq.ctle.maxgain - real gain dB
% result.eq.ctle.maxkacdc - max acdc gain (not dB)
% result.IR - inpulse response
% result.PR - pulse response (SBR_
% result.avail_signal - maximum signal after equalization
% result.avail_sig_index - index in result.IR of max signal
% result.best_SNR_ISI - best raw ISI
if OP.DEBUG ~= 0 display('eq ver 1.2') ;end
min_number_of_UI_in_response=40;
baud_rate=1/param.ui;
fnq=baud_rate/2;
fb=baud_rate;
ctle_step=param.ctle_step;
cm1_values = 0:param.tx_ffe_step:param.tx_ffe(1);
cp1_values = 0:param.tx_ffe_step:param.tx_ffe(2);
ctle_values= 0:ctle_step: param.max_ctle; % assume  param.max_ctle is a the DC dB loss i.e. use a positive number 
kacdc_values = 10.^(-ctle_values/20); % and negate here 
best_ctle = [];
best_SNR_ISI = -inf;
best_setting = [];
delta_sbr = [];
t=(-param.samples_per_ui*5):(param.samples_per_ui*20);
time_step=1/baud_rate/param.samples_per_ui;
pxi=0;
for ctle_index=1:length(kacdc_values)
    kacdc=kacdc_values(ctle_index);
    best_sbr_h = [];
    hwaitbar=waitbar(0);
    [impulse_response p1_ctle, p2_ctle, z_ctle] = TD_CTLE(ir_in,fb,kacdc,param.samples_per_ui);
    for k_cm1=1:length(cm1_values)
        cm1=cm1_values(k_cm1);
        for k_cp1=1:length(cp1_values)
            cp1=cp1_values(k_cp1);
            pxi=pxi+1;
            progress = pxi/( length(cm1_values)*length(cp1_values)*length(kacdc_values) );
            waitbar(progress, hwaitbar, 'Processing THRU SBR'); drawnow;
            
            txffe = [-cm1, 1-cm1-cp1, -cp1];
            if txffe(2)<max(abs(txffe))
                continue;
            end
            upsampled_txffe = zeros(1, param.samples_per_ui*2+1); % start with zeros everywhere
            upsampled_txffe(1+(0:2)*param.samples_per_ui) = txffe; % plant the coefficients in the desired locations
            effective_channel = conv(impulse_response,upsampled_txffe );
            sbr=conv(ones(param.samples_per_ui, 1), effective_channel);
            [NA, sbr_peak_i]=max(abs(sbr));
            triple_transit_time = round(sbr_peak_i*2/param.samples_per_ui)+20;
            if min_number_of_UI_in_response < triple_transit_time
                min_number_of_UI_in_response = triple_transit_time;
            end
%          test omitted assume we always have an SBR with a peak
%          if isempty(delta_sbr) 
                cursor_i = sbr_peak_i;
%          else
                zxi = find(diff(sign(sbr-.01*max(sbr)))>=1); % added the = 
                zxi = zxi(zxi<sbr_peak_i);
                zxi = zxi(sbr_peak_i - zxi < 3*param.samples_per_ui);% made 3 UI to accommodate high dispersion channels 
                if isempty(zxi)
                    continue;
                elseif length(zxi)>1
                    fprintf('Warning: multiple zero corssings found for ffe=%s. Using last\n', ...
                        mat2str(txffe));
                    zxi=zxi(end);
                end
                cursor_i = zxi+param.samples_per_ui+1;
%          end
            cursor = sbr(cursor_i);
            if isempty(delta_sbr)
                delta_sbr = sbr;
                delta_cursor_i = cursor_i;
                delta_cursor = cursor;
            end
            sbr=sbr(:);
            %             d(1:param.ndfe)=sbr((cursor_i+param.samples_per_ui*(1:param.ndfe)));
            %             dfe_cursors=[];
            %             for dix = 1:param.ndfe
            %                 dfe_cursors =  [dfe_cursors (sbr((cursor_i+param.samples_per_ui*dix):(cursor_i+param.samples_per_ui*(dix+1)))-d(dix))'];
            %             end
            %             dfe_cursors=dfe_cursors(:);
            far_cursors = sbr(cursor_i+param.samples_per_ui*(param.ndfe+1):param.samples_per_ui:end);
            %            precursors = sbr(cursor_i+param.samples_per_ui*(-3:-1));
            precursors = sbr(cursor_i+param.samples_per_ui*(-3):cursor_i+param.samples_per_ui*(-2));
            dfecursors = sbr(cursor_i+param.samples_per_ui*(1):cursor_i+param.samples_per_ui*(param.ndfe+1))-...
                sign(sbr(cursor_i+param.samples_per_ui*(1):cursor_i+param.samples_per_ui*(param.ndfe+1)))...
                .*min(param.maxcx*sbr(cursor_i),abs(sbr(cursor_i+param.samples_per_ui*(1):cursor_i+param.samples_per_ui*(param.ndfe+1))));
            
            residual_isi_rms =sqrt( norm([precursors; dfecursors; far_cursors])^2+(param.G_s_noise*cursor)^2+param.Na_rms^2 );
            %           residual_isi_rms =max(sqrt( norm([precursors; far_cursors; dfe_cursors])^2+(param.G_s_noise*cursor)^2), param.Na_rms);
            
            %            residual_isi_rms =max(sqrt( norm([precursors; far_cursors])^2+(param.G_s_noise*cursor)^2), 0);
            SNR_ISI = 20*log10(cursor/residual_isi_rms);
            if (SNR_ISI > best_SNR_ISI) %&& (abs(sbr(cursor_i-param.samples_per_ui)) <= max(sbr)/20)
                egn=sbr((cursor_i+param.samples_per_ui*2):(cursor_i+param.samples_per_ui*param.ndfe));
                if max(abs(egn))/sbr(cursor_i) >= param.maxcx
                    continue;
                end
                % need to set best if loop alway continues ie to much ISI
                best_setting = txffe;
                best_sbr = sbr;
                best_ctle.kacdc =kacdc;
                best_ctle.p1=p1_ctle; % for a 1 pole does this need to be inf
                best_ctle.p2 = p2_ctle;
                best_ctle.z = z_ctle;
                best_SNR_ISI = SNR_ISI;
                best_cursor_i = cursor_i;
                best_IR=effective_channel;
                %           fprintf('found new best setting: %s\n', mat2str(txffe));
            end
        end
    end
end

if ~exist('best_cursor_i')% take last setting
                best_setting = txffe;
                best_sbr = sbr;
                best_ctle.kacdc =kacdc;
                best_ctle.p1=p1_ctle; % for a 1 pole does this need to be inf
                best_ctle.p2 = p2_ctle;
                best_ctle.z = z_ctle;
                best_SNR_ISI = SNR_ISI;
                best_cursor_i = cursor_i;
                best_IR=effective_channel;   
end
t=(-param.samples_per_ui*5):(param.samples_per_ui*min_number_of_UI_in_response);
best_cursor = best_sbr(best_cursor_i);
precursors = best_sbr(best_cursor_i+param.samples_per_ui*(-4:-1));
postcursors = best_sbr(best_cursor_i+param.samples_per_ui*(1:min_number_of_UI_in_response));
isi_contributors = [precursors', postcursors(param.ndfe+1:end)'];
pre_emphasis_loss = 20*log10(best_cursor/delta_cursor);
% report during debug
PRin=conv(ones(param.samples_per_ui, 1), ir_in);
f=1e8:1e8:100e9;
%ctle_gain=(1+1i*2*pi*f/best_ctle.z)./((1+1i*2*pi*f/best_ctle.p1).*(1+1i*2*pi*f/best_ctle.p2))/best_ctle.kacdc;
ctle_gain=fb*(1i.*f+0.25*fb*best_ctle.kacdc)./((1i*f+0.25*fb).*(1i*f+fb));
if OP.DEBUG ~=0
    display(['Taps coef:     ', num2str(best_setting) ] );
    display(['IR first pass SNR ' ,num2str(20*log10(best_SNR_ISI)),'dB']);
    display(['Ctle acdc gain ' ,num2str(20*log10(best_ctle.kacdc)), 'dB']);
    display(['Max CLTE peaking gain ' ,num2str(20*log10(max(abs(ctle_gain)))), 'dB']);
    display(['Available signal = ' ,num2str(best_cursor)]);
    figure(101)
    semilogx(f,20*log10(abs(ctle_gain)))
    hold on
    fbaud_tick=find(f >= baud_rate); fbaud_tick =fbaud_tick(1);
    fnq_tick=find(f >= baud_rate/2); fnq_tick =fnq_tick(1);
    stem(f(fnq_tick),20*log10(abs(ctle_gain(fnq_tick))),'g')
    stem(f(fbaud_tick),20*log10(abs(ctle_gain(fbaud_tick))),'g')
    title('CTLE response')
    ylabel('dB')
    xlabel('Hz')
    hold off
    figure(100)
    plot(t*1/baud_rate/param.samples_per_ui,best_sbr(1:length(t)),'disp', 'PR eq');
    hold on
    PRplt(1:param.samples_per_ui+5)=PRin(1);
    PRplt(param.samples_per_ui+6:length(t))=PRin(1:length(t)-param.samples_per_ui-5);
    plot(t*1/baud_rate/param.samples_per_ui,PRplt(1:length(t)),'r','disp','PR in');
    stem(t(best_cursor_i)*1/baud_rate/param.samples_per_ui,best_sbr(best_cursor_i),'g');
    title('SBR responses')
    ylabel('volts')
    xlabel('seconds')
    grid on
    hold off
end
close(hwaitbar);
% eq_data
result.eq.txle=best_setting;
result.eq.ctle.zero=best_ctle.z;
result.eq.ctle.pole1=best_ctle.p1;
result.eq.ctle.pole2=best_ctle.p2;
result.eq.ctle.maxgain=20*log10(max(abs(ctle_gain)));
result.eq.ctle.maxkacdc=best_ctle.kacdc;
%
result.IR=best_IR;
result.PR=PRin;
result.avail_signal=best_cursor;
result.avail_sig_index=best_cursor_i;
result.best_SNR_ISI=best_SNR_ISI;


function [ result_sbr tci tzi ] = find_g_param(ir, param )
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here
reduce_ui=round(param.G_dd_noise*2*param.samples_per_ui);
sbr=conv(ones(param.samples_per_ui-reduce_ui, 1), ir);
[NA, sbr_peak_i]=max(abs(sbr));
zxi = find(diff(sign(sbr))>1);
zxi = zxi(zxi<sbr_peak_i);
zxi = zxi(sbr_peak_i - zxi < 2*(param.samples_per_ui-reduce_ui));    
if length(zxi)>1
    fprintf('Warning: multiple zero corssings found for ffe=%s. Using last\n', ...
        mat2str(txffe));
    zxi=zxi(end);
end
tci = zxi+param.samples_per_ui-reduce_ui+1;
tzi= zxi;
result_sbr=sbr;



%% TD CTLE function
    function [impulse_response p1_ctle, p2_ctle, z_ctle] = TD_CTLE(ir_in,fb,kacdc,oversampling)
        fnq=fb/2;
        baud_rate=fb;
        p1_ctle = -2*pi*fnq/2;
        p2_ctle = -2*pi*(2*fnq);
        z_ctle = p1_ctle*kacdc;
        k_ctle = -p2_ctle;
        bilinear_fs = 2*baud_rate*oversampling;
        p2d = (1+p2_ctle/bilinear_fs)./(1-p2_ctle/bilinear_fs);
        p1d = (1+p1_ctle/bilinear_fs)./(1-p1_ctle/bilinear_fs);
        zd = (1+z_ctle/bilinear_fs)./(1-z_ctle/bilinear_fs);
        kd = (bilinear_fs-z_ctle)/((bilinear_fs-p1_ctle)*(bilinear_fs-p2_ctle));
        B_filt =k_ctle*kd*poly([zd, -1]);
        A_filt=poly([p1d, p2d]);
        impulse_response=filter(B_filt,A_filt,ir_in);

%% PDF from interference vector
function [ pdf ] = get_pdf_from_sampled_signal( input_vector,coding )
%   input_vector = list of values of samples
%   return
%   pdf.x
%   pdf.y
%   pdf.vec
%   pdf.bin
BinSize=1e-4;
 if max(input_vector) > BinSize
     input_vector=input_vector(abs(input_vector)>BinSize);
 end
 for i = 1:length(input_vector)
     if abs(input_vector(i)) < BinSize , input_vector(i)=0; end
 end
if strfind(upper(coding),'PAM4') == 1
    values=[-abs(input_vector(1)) -abs(input_vector(1))/3 +abs(input_vector(1))/3 +abs(input_vector(1)) ];
    prob=[.25 .25 .25 .25];
else
    values=[-abs(input_vector(1)) +abs(input_vector(1))];
    prob=[.5 .5];
end
pdf=d_cpdf(BinSize, values, prob);
if length(input_vector) >= 2
    for i = 2:length(input_vector)
        if strfind(upper(coding),'PAM4') == 1
            values=[-abs(input_vector(i)) -abs(input_vector(i))/3 +abs(input_vector(i))/3 +abs(input_vector(i)) ];
            prob=[.25 .25 .25 .25];
        else
            values=[-abs(input_vector(i)) +abs(input_vector(i))];
            prob=[.5 .5];
        end
        
        pdfn=d_cpdf(BinSize, values, prob);
        pdf=conv_fct(pdf, pdfn);
    end
else
    pdfn.y=1;
    pdfn.Min=0;
    pdfn.BinSize=pdf.BinSize;
    pdf=conv_fct(pdf, pdfn);
end

function pdf=d_cpdf( binsize, values, probs)
%  p=cpdf(type, ...)
% 
% CPDF is actually a PMF for discrete distributions.
% Operations on CPDF objects currently require both objects to have the
% same bin size.
% cpdf(..., 'bin_size', B) sets the bin size to B instead of the default.
%
% cpdf is internally normalized so that the sum of probabilities is 1 
% (regardless of bin size).

% Internal fields:
% Min: *bin number* of minimum value.
% BinSize: size of PDF bins. Bin center is the representative value.
% Vec: vector of probabilities per bin.

values=binsize*round(values/binsize);
t=(min(values):binsize:max(values));
pdf.Min=min(values)/binsize;
pdf.y=zeros(size(t));
for k=1:length(values)
    [NA, bin]=min(abs(t-values(k)));
    if isempty(bin)
        warning('no bin');
    end
    pdf.y(bin) = pdf.y(bin)+probs(k);
end

pdf.BinSize=binsize;
pdf.y=pdf.y/sum(pdf.y);
if any(~isreal(pdf.y)) || any(pdf.y<0)
    error('PDF must be real and nonnegative');
end
support=find(pdf.y);
pdf.y=pdf.y(support(1):support(end));
pdf.Min=pdf.Min+(support(1)-1);

function p=conv_fct(p1, p2)
if p1.BinSize ~= p2.BinSize
	error('bin size must be equal')
end

N1=length(p1.y);
N2=length(p2.y);
p=p1;
p.BinSize=p1.BinSize;
p.Min=p1.Min+p2.Min;
p.y=conv(p1.y, p2.y);
p.x =p.Min*p.BinSize:p.BinSize:-p.Min*p.BinSize;

function pdf = normal_dist(sigma,nsigma,binsize)
        pdf.BinSize=binsize;
        pdf.Min=-round(nsigma*sigma/binsize);
        pdf.x=(pdf.Min:-pdf.Min)*binsize;
        pdf.y=exp(-pdf.x.^2/(2*sigma^2+eps));
        pdf.y=pdf.y/sum(pdf.y);

function [ param OP ]= read_ParamConfigFile(paramFile, param, OP)
    warning('off','MATLAB:xlsread:Mode'); % suppress warning messages for reading the settings file from XLS
    [na1, na2, parameter] = xlsread(paramFile,'','','basic'); % Import data from the settings file (imports the entire sheet)
    
    % exit if a parameter is missing otherwise initialize and set the parameter variable 
    if (isnan(parameter{2,2})); missingParameter('Coding/Interface Type'); else param.type = upper(strtrim(parameter{2,2})); end
    
    % Sanity check to determine if the specific XLS cell(s) contain information.
    % This does not determine if that information is correct. A more extensive
    % sanity check would be required.
    if (isnan(sum(parameter{3,2}))); 
        missingParameter('Signal Rate (fb)'); 
    else 
        param.fb = parameter{3,2}*1e9;
        param.ui=1/param.fb;
    end
    if (isnan(sum(parameter{4,2}))); missingParameter('[c(-1) c(1)]'); else param.tx_ffe = -eval(parameter{4,2}); end
    if (isnan(sum(parameter{5,2}))); missingParameter('Nb'); else param.ndfe = parameter{5,2}; end
    if (isnan(sum(parameter{6,2}))); missingParameter('Gdc, for CTF'); else param.max_ctle = -parameter{6,2}; end
    if (isnan(sum(parameter{7,2}))); missingParameter('Av'); else param.a_thru = parameter{7,2}; end
    if (isnan(sum(parameter{8,2}))); missingParameter('Af'); else param.a_fext = parameter{8,2}; end
    if (isnan(sum(parameter{9,2}))); missingParameter('An'); else param.a_next = parameter{9,2}; end
    if (isnan(sum(parameter{10,2}))); 
        missingParameter('L'); 
    else
        param.levels = parameter{10,2};
        param.AG=1/(parameter{10,2}-1);
        if param.levels == 2,  param.coding='NRZ'; else param.coding='PAM4'; end
    end
    if (isnan(sum(parameter{11,2}))); missingParameter('SER0'); else param.specBER = parameter{11,2}; end
    if (isnan(sum(parameter{12,2}))); missingParameter('CC1'); else param.cc1 = parameter{12,2}; end
    if (isnan(sum(parameter{13,2}))); missingParameter('sigma_rj'); else param.G_s_noise = parameter{13,2}; end
    if (isnan(sum(parameter{14,2}))); missingParameter('Add'); else param.G_dd_noise = parameter{14,2}; end
    if (isnan(sum(parameter{15,2}))); missingParameter('sigma_r'); else param.Na_rms = parameter{15,2}; end
    if (isnan(sum(parameter{16,2}))); missingParameter('Sample Per UI'); else param.samples_per_ui = parameter{16,2}; end
    if (isnan(sum(parameter{17,2}))); missingParameter('Port Order'); else param.snpPortsOrder = eval(parameter{17,2}); end
    if (isnan(sum(parameter{18,2}))); missingParameter('Gamma_01'); else param.G01 = (parameter{18,2}); end
    if (isnan(sum(parameter{19,2}))); missingParameter('Gamma_02'); else param.G02 = (parameter{19,2}); end
    if (isnan(sum(parameter{20,2}))); missingParameter('f1'); else param.f1 = (parameter{20,2})*1e9; end
    if (isnan(sum(parameter{21,2}))); missingParameter('f2'); else param.f2 = (parameter{21,2})*1e9; end
    if (isnan(sum(parameter{22,2}))); missingParameter('CTF_step'); else param.ctle_step = (parameter{22,2}); end
    if (isnan(sum(parameter{23,2}))); missingParameter('TXFFE_step'); else param.tx_ffe_step = (parameter{23,2}); end
    if (isnan(sum(parameter{25,2}))); missingParameter('bmax'); else param.maxcx = (parameter{24,2}); end
    if (isnan(sum(parameter{26,2}))); missingParameter('f_v'); else param.f_v = (parameter{25,2}); end
    if (isnan(sum(parameter{27,2}))); missingParameter('f_f'); else param.f_f = (parameter{26,2}); end
    if (isnan(sum(parameter{28,2}))); missingParameter('f_n'); else param.f_n = (parameter{27,2}); end
    if (isnan(sum(parameter{29,2}))); missingParameter('f_r'); else param.f_r = (parameter{28,2}); end
    if (isnan(sum(parameter{30,2}))); missingParameter('PKG_a1'); else  param.pkg.a1= (parameter{29,2}); end
    if (isnan(sum(parameter{31,2}))); missingParameter('PKG_a2'); else  param.pkg.a2= (parameter{30,2}); end
    if (isnan(sum(parameter{32,2}))); missingParameter('PKG_a4'); else  param.pkg.a4= (parameter{31,2}); end
    if (isnan(sum(parameter{33,2}))); missingParameter('PKG_L_tl'); else  param.pkg.L_tl= (parameter{32,2}); end
    if (isnan(sum(parameter{34,2}))); missingParameter('PKG_C_d'); else param.pkg.C_d = (parameter{33,2}); end
    if (isnan(sum(parameter{35,2}))); missingParameter('PKG_C_b'); else  param.pkg.C_b= (parameter{34,2}); end
    if (isnan(sum(parameter{36,2}))); missingParameter('PKG_vp'); else  param.pkg.vp= (parameter{35,2}); end
    if (isnan(sum(parameter{35,2}))); missingParameter('PKG_R0'); else  param.pkg.R0= (parameter{36,2}); end
    if (isnan(sum(parameter{36,2}))); missingParameter('PKG_Etl'); else  param.pkg.etl= (parameter{37,2}); end

    if (isnan(sum(parameter{2,6}))); missingParameter('INCLUDE_CTLE'); else OP.INCLUDE_CTLE = parameter{2,6}; end
    if (isnan(sum(parameter{3,6}))); missingParameter('INCLUDE_FILTER'); else OP.INCLUDE_FILTER = parameter{3,6}; end
    if (isnan(sum(parameter{4,6}))); missingParameter('DEBUG'); else OP.DEBUG = parameter{4,6}; end
    if (isnan(sum(parameter{5,6}))); missingParameter('DISPLAY_WINDOW'); else OP.DISPLAY_WINDOW = parameter{5,6}; end
    if (isnan(sum(parameter{6,6}))); missingParameter('CSV_REPORT'); else OP.CSV_REPORT = parameter{6,6}; end
    if (isnan(sum(parameter{7,6}))); missingParameter('SAVE_RESP'); else OP.SAVE_RESP = parameter{7,6}; end
    if (isnan(sum(parameter{8,6}))); missingParameter('GET_FD'); else OP.GET_FD = parameter{8,6}; end
    if (isnan(sum(parameter{9,6}))); missingParameter('INC_PACKAGE_RL'); else OP.INC_PACKAGE_RL = parameter{9,6}; end
    if (isnan(sum(parameter{9,6}))); missingParameter('EXTERNAL'); else OP.EXTERNAL = parameter{10,6}; end
    if (isnan(sum(parameter{11,6}))); missingParameter('RESULT_DIR'); else OP.RESULT_DIR = parameter{11,6}; end
    if (isnan(sum(parameter{9,6}))); missingParameter('INC_PACKAGE_IL'); else OP.INC_PACKAGE_IL = parameter{12,6}; end
    
    
    % Parameters computationally defined by values from the settings files
    % set up sampling
    param.sample_dt = param.ui/param.samples_per_ui;
    param.f2 = 1/param.ui;  % used for ICN intregals
    param.fb = 1/param.ui;  % used for the filter for ICN
    param.thru = true;      % input thru channel is always present

function missingParameter (parameterName)
%% FUNCTION :: missingParameter
%
% Description
%   Generates an error message and exits the program due to a parameter in the
%   settings configuration file missing
%
% Input Variables (required)
%   parameterName -- the name of the parameter that has the missing information%   
%
% Output/Return Variables
%
% Local Variables (scoped locally to current function only)
    error( 'warning:badParameterInformation', ...
        '\n\n\t The data for %s is missing or incorrect \n' , upper(parameterName));
%end % missingParameter



function [ H_f  ] = pkg_loss( f1 , param, OP )
f=f1/1e9;

idxf12p9=find(f1>=param.fb/2,1);
% param.pkg.a1= 2.9126;
% param.pkg.a2= .4835;
% param.pkg.a4= .0587;
% param.pkg.L_tl= 7.07e-3;
% param.pkg.C_d = 2.5e-4;
% param.pkg.C_b= 2.2e-4;
% param.pkg.vp= .182;
% param.pkg.R0= 50;
% param.pkg.etl= 11.9;


s21 = exp(-param.pkg.L_tl * ( param.pkg.a1*sqrt(f) + param.pkg.a2*f + param.pkg.a4*f.^2+1i*2*pi*f/param.pkg.vp ));
s12=s21;

G_die =  -1i*f./( 1./(pi*param.pkg.C_d*param.pkg.R0)+1i.*f );
G_ball = -1i*f./( 1./(pi*param.pkg.C_b*param.pkg.R0)+1i.*f );


s11 = param.pkg.etl/(200+param.pkg.etl);
s22 = s11;
%H_f = Pure_Loss ./ (1 - (G_die.* param.pkg.Gtl + G_ball.*param.pkg.Gtl + G_die.*G_ball.*Pure_Loss.^2 - G_die.*G_ball.*param.pkg.Gtl.*param.pkg.Gtl));
H_f = s21./(1-s11.*G_die-s22*G_ball+G_die.*G_ball.*(s11.*s22-s21.*s12));
if OP.DEBUG
    figure(305);
    ilatnq=num2str(20*log10(abs(H_f(idxf12p9))));
    subplot(3,1,1); plot(f, 20*log10(abs(s21)), f, 20*log10(abs(G_die)), f, 20*log10(abs(G_ball)));
    subplot(3,1,2); plot(f, 20*log10(abs(H_f)),'disp',['IL at Fnq= ' ilatnq]);
    legend show
    subplot(3,1,3); plot(f, unwrap(angle(s21))/pi*180, f, unwrap(angle(H_f))/pi*180);
end