function [C]=solarsep_varlen2(anextcanc,bwmhz,con,lline,CAT,defaultnoisecanc,style,useilmodel,margindB,codegaindB);
% 100m IL is scaled based on lline, from 100m ad hoc models, with connector contribution removed & added
% back after scaling
% FEXT is selected from closest of ad hoc 50, 75 & 100m models
% Other impairments are unchanged (Pessimistic)
% con is either 2 or 4 and represents how many connectors to be used in cable model
% there only is a 4 connector model for CAT7 as of 9/10/03.
% these are the only measurements available until now.
% based on cat 5 diminico data --from ad-hoc models.
% CAT is 5,6, or 7 
% defaultnoisecanc=1 means that the standard Solarflare cancellation levels are applied (otherwise perfect cancellation is assumed)
% style is either 1, 2, or 3 depending on how the user wants to see the plots.
% useilmodel=1 if you want to use the insertion loss models
% margindB should be 0 if you want standard capacity #'s
% otherwise it uses Cioffi's approximation of integrating log2(1+SNRdB+codegaindB-(gapdB+margindB))
% C is the "capacity", assuming a flat transmit power spectral density. 
% 10GBASE-T channel capacity estimation program based on ISO cable models
% For IEEE802.3 10GBase-T SG
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The frequency range used to estimate the channel capacity is [0,bwmhz]
% presentation in San Francisco had Shadi's alien next xtalk measurements...this corresponds to oldway=0.
% written by Carlos Aldana, Solarflare Communications.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin==8, %to do capacity.
    margindB=0;
    codegaindB=12.27; % gap for 1e-12 BER, 8 PAM.
end
if codegaindB>12.27,
    error('you are now about to enter a world where you exceed the Shannon limit!')
end
if margindB<0,
    margindB=0;
end
if (CAT==7 & con==2),
    error('do not have data for this case')
end
if bwmhz<417,
    error('need to select larger bw')
end
oldway=0; %0 is for cat 6 alien next results.
makeplots=1; % makeplots = 1 to generate plots
whitedBm=-150; %dBm/Hz...default is -150
if defaultnoisecanc==1,
        nextcanc=40;
        echocanc=55;
        fextcanc=25;
else
        nextcanc=100;
        echocanc=100;
        fextcanc=100;
        anextcanc=100;
end
% default 40, 55, 25
P=10; % P -%input power (dBm)
if (CAT==6 | CAT==7),
    df=750e3; 
else
    df=812.5e3;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Insertion Loss based on Chris DiMinico's models.
% ISO 11801 Channel-Class D and Class E.xls
% note all these have an extra 5 m of patch cord.
% these are not the standard lmt lnes

if CAT==6,
    if con==4,
        load ilcat6_4conn.txt
        freq2=ilcat6_4conn(:,1);%freq2 is given in MHz
        if lline==100,
            if useilmodel==0,
                IL1=-ilcat6_4conn(:,2);
            else
                IL1=-(1.1*(1.82*sqrt(freq2)+0.0169*freq2+0.25./sqrt(freq2))+4*0.02*sqrt(freq2));
                %IL1=-(1.05*(1.9108*sqrt(freq2)+0.0222*freq2+0.2./sqrt(freq2))+4*0.04*sqrt(freq2));
            end
        else
            if useilmodel==0,
                IL1=-(lline/100*(ilcat6_4conn(:,2)-4*0.02*sqrt(freq2))+4*0.02*sqrt(freq2)); %remove connectors & scale IL
            else
                IL1=-(lline/100*1.1*(1.82*sqrt(freq2)+0.0169*freq2+0.25./sqrt(freq2))+4*0.02*sqrt(freq2));
            end
        end
    elseif con==2,
        load ilcat6_2conn.txt 
        freq2=ilcat6_2conn(:,1);%freq2 is given in MHz
        if lline==100,
            if useilmodel==0,    
                IL1=-ilcat6_2conn(:,2);
            else
                IL1=-(1.1*(1.82*sqrt(freq2)+0.0169*freq2+0.25./sqrt(freq2))+2*0.02*sqrt(freq2));
                %IL1=-(1.05*(1.9108*sqrt(freq2)+0.0222*freq2+0.2./sqrt(freq2))+2*0.04*sqrt(freq2));
            end
        else
            if useilmodel==0,
                IL1=-(lline/100*(ilcat6_2conn(:,2)-2*0.02*sqrt(freq2)))+2*0.02*sqrt(freq2); %remove connectors & scale IL
            else
                IL1=-(lline/100*1.1*(1.82*sqrt(freq2)+0.0169*freq2+0.25./sqrt(freq2))+2*0.02*sqrt(freq2));
            end
        end
    end
elseif CAT==5,
    if con==4,
        load il_4conn.txt
        freq2=il_4conn(:,1);%freq2 is given in MHz
        if lline==100,
            if useilmodel==0,
                IL1=-il_4conn(:,2);
            else
                 IL1=-(1.1*(1.9108*sqrt(freq2)+0.0222*freq2+0.2./sqrt(freq2))+4*0.04*sqrt(freq2));
      
            end
        else
             if useilmodel==0,
                IL1=-(lline/100*(il_4conn(:,2)-4*0.04*sqrt(freq2))+4*0.04*sqrt(freq2));
            else
                 IL1=-(lline/100*1.1*(1.9108*sqrt(freq2)+0.0222*freq2+0.2./sqrt(freq2))+4*0.04*sqrt(freq2));
            end
        end
    elseif con==2,
        load ilcat5_2conn.txt
        freq2=ilcat5_2conn(:,1);%freq2 is given in MHz
        if lline==100,
            if useilmodel==0,
                IL1=-ilcat5_2conn(:,2);
            else
                 IL1=-(1.1*(1.9108*sqrt(freq2)+0.0222*freq2+0.2./sqrt(freq2))+2*0.04*sqrt(freq2));
            end
        else
            if useilmodel==0,
                IL1=-(lline/100*(ilcat5_2conn(:,2)-2*0.04*sqrt(freq2))+2*0.04*sqrt(freq2));
            else
                 IL1=-(lline/100*1.1*(1.9108*sqrt(freq2)+0.0222*freq2+0.2./sqrt(freq2))+2*0.04*sqrt(freq2));      
            end
        end
    end         
else 
    load ilcat7_4conn_100m.txt
    freq2=ilcat7_4conn_100m(:,1);%freq2 is given in MHz
    if lline==100,
        if useilmodel==0,
            IL1=-ilcat7_4conn_100m(:,2);
        else
            IL1=-(1.1*(1.8*sqrt(freq2)+0.01*freq2+0.2./sqrt(freq2))+4*0.04*sqrt(freq2));  
        end
    else
        if useilmodel==0,
            IL1=-(lline/100*(ilcat7_4conn_100m(:,2)-4*0.04*sqrt(freq2))+4*0.04*sqrt(freq2));
        else
            IL1=-(lline/100*1.1*(1.8*sqrt(freq2)+0.01*freq2+0.2./sqrt(freq2))+4*0.04*sqrt(freq2));  
        end
    
    end
end
if makeplots
    figure(1)
    if style==1,
        plot(freq2,IL1);
    elseif style==2,
        plot(freq2,IL1,'r--');
    else
        plot(freq2,IL1,'g-.');
    end
    hold on
    grid on
    title('insertion gain(dB)')
    hold off
end
u=find(freq2>=bwmhz);
fhigh=min(u);
%freq2(fhigh)
if isempty(fhigh)
    error('error in bwmhz')
    return
end
freq2=freq2(1:fhigh);
IL1=IL1(1:fhigh);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Self PSNEXT based on Chris DiMinico's models.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if CAT==6,
    if con==4,
        load nextcat6_4conn.txt
        NX1=10*log10(10.^(-nextcat6_4conn(:,2)/10)+10.^(-nextcat6_4conn(:,3)/10)+10.^(-nextcat6_4conn(:,4)/10));
      
    elseif con==2,
        load nextcat6_2conn.txt 
        NX1=10*log10(10.^(-nextcat6_2conn(:,1)/10)+10.^(-nextcat6_2conn(:,2)/10)+10.^(-nextcat6_2conn(:,3)/10));
    end
elseif CAT==5,
    if con==4,
        load next_4conn.txt
        NX1=10*log10(10.^(-next_4conn(:,2)/10)+10.^(-next_4conn(:,3)/10)+10.^(-next_4conn(:,4)/10));
      
    elseif con==2,
        load nextcat5_2conn.txt
        NX1=10*log10(10.^(-nextcat5_2conn(:,2)/10)+10.^(-nextcat5_2conn(:,3)/10)+10.^(-nextcat5_2conn(:,4)/10));
    end
else
    load nextcat7_4conn_100m.txt 
    NX1=10*log10(10.^(-nextcat7_4conn_100m(:,1)/10)+10.^(-nextcat7_4conn_100m(:,2)/10)+10.^(-nextcat7_4conn_100m(:,3)/10));

end

NX1=NX1(1:fhigh);
if makeplots
    figure(2)
    if style==1,
       plot(freq2,NX1);
    elseif style==2,
        plot(freq2,NX1,'r--');
    else
        plot(freq2,NX1,'g-.');
    end
    hold on
    grid on
    title('next gain(dB)')
    hold off
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Self PSFEXT based on Chris DiMinico's models.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if CAT==6,
    if con==4,
        load fextcat6_4conn.txt
        if lline>87.5,
            FX1=10*log10(10.^(-fextcat6_4conn(:,1)/10)+10.^(-fextcat6_4conn(:,2)/10)+10.^(-fextcat6_4conn(:,3)/10));
            FX1=FX1-10*log10(lline/100); 
        elseif lline>62.5,
            FX1=10*log10(10.^(-fextcat6_4conn(:,4)/10)+10.^(-fextcat6_4conn(:,5)/10)+10.^(-fextcat6_4conn(:,6)/10));
            FX1=FX1-10*log10(lline/75);
        elseif lline>0,
            FX1=10*log10(10.^(-fextcat6_4conn(:,7)/10)+10.^(-fextcat6_4conn(:,8)/10)+10.^(-fextcat6_4conn(:,9)/10));
            FX1=FX1-10*log10(lline/50);
        end
    elseif con==2,
        if lline>87.5,
            load fextcat6_2conn_100m.txt 
            FX1=10*log10(10.^(-fextcat6_2conn_100m(:,1)/10)+10.^(-fextcat6_2conn_100m(:,2)/10)+10.^(-fextcat6_2conn_100m(:,3)/10));
            FX1=FX1-10*log10(lline/100);  
        elseif lline>62.5,
            load fextcat6_2conn_75m.txt
            FX1=10*log10(10.^(-fextcat6_2conn_75m(:,1)/10)+10.^(-fextcat6_2conn_75m(:,2)/10)+10.^(-fextcat6_2conn_75m(:,3)/10));
            FX1=FX1-10*log10(lline/75);  
        elseif lline>0,
            load fextcat6_2conn_50m.txt 
            FX1=10*log10(10.^(-fextcat6_2conn_50m(:,1)/10)+10.^(-fextcat6_2conn_50m(:,2)/10)+10.^(-fextcat6_2conn_50m(:,3)/10));
            FX1=FX1-10*log10(lline/50);    
        end
    end
elseif CAT==5,
    if con==4,
        load fext1_4conn.txt
        if lline<62.5,
            FX1=10*log10(10.^(-fext1_4conn(:,8)/10)+10.^(-fext1_4conn(:,9)/10)+10.^(-fext1_4conn(:,10)/10));
            FX1=FX1-10*log10(lline/50); 
        elseif lline<87.5,
            FX1=10*log10(10.^(-fext1_4conn(:,5)/10)+10.^(-fext1_4conn(:,6)/10)+10.^(-fext1_4conn(:,7)/10));
            FX1=FX1-10*log10(lline/75);
        else
            FX1=10*log10(10.^(-fext1_4conn(:,2)/10)+10.^(-fext1_4conn(:,3)/10)+10.^(-fext1_4conn(:,4)/10));
            FX1=FX1-10*log10(lline/100);    
        end
    elseif con==2,
        if lline>87.5,
            load fextcat5_2conn.txt
            FX1=10*log10(10.^(-fextcat5_2conn(:,2)/10)+10.^(-fextcat5_2conn(:,3)/10)+10.^(-fextcat5_2conn(:,4)/10));
            FX1=FX1-10*log10(lline/100);
        elseif lline>62.5,
            load fextcat5_2conn_75m.txt
            ELFX1=10*log10(10.^(-fextcat5_2conn_75m(:,1)/10)+10.^(-fextcat5_2conn_75m(:,2)/10)+10.^(-fextcat5_2conn_75m(:,3)/10));
            FX1=ELFX1+IL1;
            FX1=FX1-10*log10(lline/75);
        elseif lline>0,
            load fextcat5_2conn_50m.txt
            FX1=10*log10(10.^(-fextcat5_2conn_50m(:,1)/10)+10.^(-fextcat5_2conn_50m(:,2)/10)+10.^(-fextcat5_2conn_50m(:,3)/10));
            FX1=FX1-10*log10(lline/50);    
        end
    end
else %CAT7 
    load fextcat7_4conn_100m.txt
    FX1=10*log10(10.^(-fextcat7_4conn_100m(:,1)/10)+10.^(-fextcat7_4conn_100m(:,2)/10)+10.^(-fextcat7_4conn_100m(:,3)/10));
    FX1=FX1-10*log10(lline/100); 
end
FX1=FX1(1:fhigh);
if makeplots
    figure(3)
    if style==1,
        plot(freq2,FX1);
    elseif style==2,
        plot(freq2,FX1,'r--');
    else
        plot(freq2,FX1,'g-.');
    end
    title('fext gain(dB)')
    hold on
    grid on
    hold off
end
if CAT==5,  
    load cat5alienadhoc.txt
    ANX1=cat5alienadhoc(:,2);
    freq=cat5alienadhoc(:,1)*1e6;
    ANX1=-interp1(freq,ANX1,freq2*1e6); 
elseif CAT==6, %we scale it up to the cat 6 limit line.
    if oldway==1, 
        ANX11=-65*ones(length(freq2),1);
        ANX12=-41.1+15*log10(freq2/100);
        ANX1t=max(ANX11,ANX12); % used for plotting purposes below.
        ANX1=-2.81+ANX1; 
    else % new measurements from Shadi
        load freq_aliennext_cat6.txt
        load cat6alienadhoc.txt
        freq=freq_aliennext_cat6(:,1)*1e6;
        ANX1=interp1(freq,cat6alienadhoc,freq2*1e6); 
    end
end
if (CAT==5 | CAT==6),
    if makeplots
        figure(4)
        plot(freq2,ANX1,'--')
        grid on
        hold on
        if oldway==1,
            if CAT==6,
                plot(freq2,ANX1t)
            end 
        end
        title('alien next (dB)')
        hold off
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Return Loss based on Chris DiMinico's models.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if CAT==6,
    if con==4,
        load rlcat6_4conn.txt
        RL1=-rlcat6_4conn(:,2); 
 
    elseif con==2,
         load rlcat6_2conn.txt 
        RL1=-rlcat6_2conn(:,1); 
    end
elseif CAT==5,
     if con==4,
        load rl_4conn.txt
        RL1=-rl_4conn(:,3);
      
    elseif con==2,
        load rlcat5_2conn.txt
        RL1=-rlcat5_2conn(:,2);
    end
else %CAT7
    load rlcat7_4conn_100m.txt
    RL1=-rlcat7_4conn_100m(:,2); 

end
RL1=RL1(1:fhigh);

if makeplots
    figure(5)
    if style==1,
        plot(freq2,RL1);
    elseif style==2,
        plot(freq2,RL1,'r--');
    else
        plot(freq2,RL1,'g-.');
    end
    hold on
    grid on
    title('return gain(dB)')
    hold off
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Input signal PSD

Si=10*log10(10^(P/10)/(bwmhz*1e6))*ones(length(freq2),1); % dBm/Hz %make it a column.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% signal and noise PSD @ receiver side
So1=Si+IL1;So2=Si+IL1;So3=Si+IL1;So4=Si+IL1;
NEXT1=Si+[NX1];NEXT2=Si+[NX1];NEXT3=Si+[NX1];NEXT4=Si+[NX1];
if (CAT==5 | CAT==6),
    ANEXT1=Si+[ANX1];ANEXT2=Si+[ANX1];ANEXT3=Si+[ANX1];ANEXT4=Si+[ANX1];
    ANEXT=[ANEXT1 ANEXT2 ANEXT3 ANEXT4];
end
FEXT1=Si+[FX1];FEXT2=Si+[FX1];FEXT3=Si+[FX1];FEXT4=Si+[FX1];
ECHO1=Si+RL1;ECHO2=Si+RL1;ECHO3=Si+RL1;ECHO4=Si+RL1;
So=[So1 So2 So3 So4];
BKN=whitedBm*ones(length(Si),4);
NEXT=[NEXT1 NEXT2 NEXT3 NEXT4];
FEXT=[FEXT1 FEXT2 FEXT3 FEXT4];
ECHO=[ECHO1 ECHO2 ECHO3 ECHO4];
if (CAT==5 | CAT==6),
    ANEXT=[ANEXT1 ANEXT2 ANEXT3 ANEXT4];
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SNR after DSP
%
% ignore quantization noise now
% Background noise is unchanged
% no alien next measurements exist for CAT 7 as of 9/10/03
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rBKN=BKN;
rNEXT=NEXT-nextcanc;
rECHO=ECHO-echocanc;
rFEXT=FEXT-fextcanc;
if (CAT==6 | CAT==5),
    rANEXT=ANEXT-anextcanc;
    N=10.^(rBKN/10)+10.^(rNEXT/10)+10.^(rECHO/10)+10.^(rFEXT/10)+10.^(rANEXT/10);
else
    N=10.^(rBKN/10)+10.^(rNEXT/10)+10.^(rECHO/10)+10.^(rFEXT/10);
end
S=10.^(So/10);
SNRdB = 10*log10(S./N)-12.27+codegaindB-margindB; %Cioffi approximation
SNR=10.^(SNRdB/10);
C_f=log2(1+SNR); 
C=sum(sum(C_f))*df ;
% program assumes freq2 is upper bounded by 833MHz....so that only 1 fold takes place.
% AVGSNR_DFE_fullBW=sum(SNRdB)/length(SNRdB)+12.27-codegaindB+margindB
% undoes approximation before folding
u=find(freq2>=416.7); %for fbaud=833MHz.
f_fold=min(u);
fold_SNR=SNR(1:f_fold);
for u=f_fold+1:fhigh; fold_SNR(2*f_fold-u)=fold_SNR(2*f_fold-u)+SNR(u); end;
fold_SNR=fold_SNR*10^((12.27-codegaindB+margindB)/10);
PAM10_DFESNR = sum(10*log10(1+fold_SNR))/f_fold;
PAM10_DFEMARGIN = PAM10_DFESNR-26.2 %assumes 4.1dB coding gain with respect to 8 PAM.
if (CAT==6 | CAT==5),
    if makeplots
        figure(6); plot(freq2,So(:,1),'--',freq2,NEXT(:,1),'-.',freq2,ANEXT(:,1),'-o',freq2,FEXT(:,1),'-x',freq2,ECHO(:,1),'-+',freq2,BKN(:,1),'-*',freq2,Si,':')
        grid
        legend('signal out', 'next','alien next','fext','echo','awgn','signal in',-1)
        figure(7); plot(freq2,10*log10(S(:,1)),'--',freq2,rNEXT(:,1),'-.',freq2,rANEXT(:,1),'-o',freq2,rFEXT(:,1),'-x',freq2,rECHO(:,1),'-+',freq2,rBKN(:,1),'-*') %,freq2,10*log10(N),'-')
        grid
        legend('signal out','rem next','rem alien next','rem fext','rem echo','rem awgn',-1)
    end
else
    if makeplots
        figure(6); plot(freq2,So(:,1),'--',freq2,NEXT(:,1),'-.',freq2,FEXT(:,1),'-x',freq2,ECHO(:,1),'-+',freq2,BKN(:,1),'-*',freq2,Si,':')
        grid
        legend('signal out', 'next','fext','echo','awgn','signal in',-1)
        figure(7); plot(freq2,10*log10(S(:,1)),'--',freq2,rNEXT(:,1),'-.',freq2,rFEXT(:,1),'-x',freq2,rECHO(:,1),'-+',freq2,rBKN(:,1),'-*') %,freq2,10*log10(N),'-')
        grid
        legend('signal out','rem next','rem fext','rem echo','rem awgn',-1)
    end
end